//========================= AQMSG.HPP ===================================
//  AutoQueueMessage class is derived from AutoQueue by the user.
//  R. Scott Guthrie - Original Code Creation
//=======================================================================
#ifndef __AQMSG_HPP
#define __AQMSG_HPP
#include <cstring.h>         // Borland 4.02 string class definition.
#include "AUTOQ.HPP"         // Include base class definitions.

// ===== AutoQueueMessage Class   (Derived from AutoQueue) =====
class AutoQueueMessage : public AutoQueue
{
  public:
    // ----- Constructors / Destructor -----
    // Constructor used to create a Non-Linked AutoQueueMessage entry.
    // Data Items 'Number_' and 'Text_' are initialized.
    AutoQueueMessage(int Number, string& Text) : AutoQueue(),
                     Number_(Number), Text_(Text) { }

    // Constructor used to create the AutoQueueMessage entry.
    // Data Items 'Number_' and 'Text_' are initialized.
    AutoQueueMessage(AutoQueueMessage** QHead, int Number, string& Text):
          AutoQueue((AutoQueue**)QHead), Number_(Number), Text_(Text) { }

    ~AutoQueueMessage() { }

    // Specialized copy type constructor.
    // Copies an AutoQueueMessage instance to a stand alone instance.
    // Source can be a stand alone instance or a member of a list.
    AutoQueueMessage(const AutoQueueMessage* Source):
          AutoQueue(), Number_(Source->Number_), Text_(Source->Text_) { }

    // Specialized copy type constructor.
    // Copies an AutoQueueMessage instance to a specified list.
    // Source can be a stand alone instance or a member of a list.
    AutoQueueMessage(AutoQueueMessage** QHead, const AutoQueueMessage* Source):
          AutoQueue((AutoQueue**)QHead), Number_(Source->Number_),
                     Text_(Source->Text_) { }

    void List();    // List all elements in the list.

    // Find an instance in the list that matches the integer 'Match'.
    AutoQueueMessage* FindByNumber(const int Match);

  private:
    // Prohibit these default methods.   (Do not define these functions)
    AutoQueueMessage();
    AutoQueueMessage(const AutoQueueMessage& rhs);
    AutoQueueMessage& operator=(const AutoQueueMessage& rhs);

  protected:
    int Number_;      // AutoQueueMessage data value.
    string Text_;     // AutoQueueMessage data value.
};
#endif
// end file AQMSG.HPP
