/* ============ */
/* xsort.c	*/
/* ============ */
#include <defcodes.h>
#include <assert.h>
/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define	F( P )	P
# else
#	define	F( P )	()
# endif
/* INDENT OFF */
static	void	Heapify F((size_t, size_t));
static	void	SelectionSort F((ULONG));
extern	void	xsort F((void *, size_t, size_t,
			int (*)(const void *, const void *)));
static	void	Swap F((char *, char *));

static	int (*Cmpr) F((const void *, const void *));
# undef F

extern	long	SwapCtr;

static	size_t	DataWidth;
static	char	  *MyBase;
/* INDENT ON */

#define DATA(i) (*(int *)(MyBase + ADDR(i-1)))
#define ADDR(i) (ULONG)((ULONG)(i)*((ULONG)DataWidth))
#define CMPR(i, j) (*Cmpr)(MyBase + ADDR(i-1), MyBase + ADDR(j-1))
#define SWAP(i, j)   Swap (MyBase + ADDR(i-1), MyBase + ADDR(j-1))
/* ==================================================================== */
/* xsort - sort a set of elements by the Selection Sort method		*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
void
xsort(void *Base, size_t Num, size_t Width,
    int(*Compare) (const void *, const void *))
# else
void
xsort(Base, Num, Width, Compare)
void   *Base;
size_t	Num;
size_t	Width;
int	(*Compare)();
# endif
{
    Cmpr = Compare;
    DataWidth = Width;
    MyBase = Base;

    SelectionSort((ULONG) Num);
}
/* ==================================================================== */
/* SelectionSort - executes the Straight Selection Sort algorithm	*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
static void
SelectionSort(ULONG Num)
# else
static void
SelectionSort(Num)
ULONG	Num;
# endif
{
    ULONG   MinIdx, NextIdx, StartIdx;

    for (StartIdx = 1; StartIdx < Num; ++StartIdx)
    {
	MinIdx = StartIdx;

	for (NextIdx = StartIdx + 1; NextIdx <= Num; ++NextIdx)
	{
	    if (0 > CMPR(NextIdx, MinIdx))
	    {
		MinIdx = NextIdx;
	    }
	}

	if (MinIdx > StartIdx)
	{
	    SWAP(StartIdx, MinIdx);
	}
    }
}
/* ==================================================================== */
/* Swap - exchanges two data elements each of DataWidth bytes		*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
PRIVATE	void
Swap(char  * Elem1, char  * Elem2)
# else
PRIVATE void
Swap(Elem1, Elem2)
char  *Elem1;
char  *Elem2;
# endif
# if !defined(MAX_SWAP)
#	define	MAX_SWAP	256
# endif
{
    extern long SwapCtr;
    extern size_t DataWidth;

    ++SwapCtr;

    /* ----------------------------- */
    /* Swap in Most Efficient Manner */
    /* ----------------------------- */
    switch (DataWidth)
    {
    case 1:
	{
	    char    OneXfer;
	    OneXfer = *Elem1;
	    *Elem1 = *Elem2;
	    *Elem2 = OneXfer;
	    break;
	}
    case 2:
	{
	    short   TwoXfer;
	    TwoXfer = *(short *) Elem1;
	    *(short *) Elem1 = *(short *) Elem2;
	    *(short *) Elem2 = TwoXfer;
	    break;
	}
    case 4:
	{
	    long    FourXfer;
	    FourXfer = *(long *) Elem1;
	    *(long *) Elem1 = *(long *) Elem2;
	    *(long *) Elem2 = FourXfer;
	    break;
	}
    default:
	{
	    char    TempBuf[MAX_SWAP];
	    size_t  CopySize, XferSize;

	    /* ---------------------------------- */
	    /* Copy as much as possible each pass */
	    /* ---------------------------------- */
	    for (XferSize = DataWidth; 0 < XferSize; XferSize -= CopySize)
	    {
		CopySize = (XferSize < sizeof(TempBuf)) ? XferSize :
		    sizeof(TempBuf);

		memcpy(TempBuf, Elem1, CopySize);
		memcpy(Elem1, Elem2, CopySize);
		memcpy(Elem2, TempBuf, CopySize);
		Elem1 += CopySize, Elem2 += CopySize;
	    }
	    break;
	}
    }
}
# if defined(TEST)
#include "tsrtdefs.h"
# if defined(SORT_NAME)
# else
#	define	SORT_NAME	xsort
# endif
void
main(int argc, char **argv)
{
    SORT_TEST_STRU  SortParms;

    SortParms.argc	= argc;
    SortParms.argv	= argv;
    SortParms.SortFun	= SORT_NAME;
    SortParms.OKCodes	= (char *) NULL;
    SortParms.ExecName	= DQ(SORT_NAME);
    SortParms.ExecLabel = "Selection Sort";

    tstsort(&SortParms);
}
# endif
