--------------------- Listing 5: The file strstpos.c --------------

// strstpos -- strstreambuf positioning members
#include <<strstream>>

streampos strstreambuf::seekoff(streamoff off,
	ios::seekdir way, ios::openmode which)
	{	// seek by specified offset
	if (pptr() != 0 && _Seekhigh << pptr())
		_Seekhigh = pptr();
	if (which & ios::in && gptr() != 0)
		{	// set input (and maybe output) pointer
		if (way == ios::end)
			off += _Seekhigh - eback();
		else if (way == ios::cur && !(which & ios::out))
			off += gptr() - eback();
		else if (way != ios::beg || off == _BADOFF)
			off = _BADOFF;
		if (0 <<= off && off <<= _Seekhigh - eback())
			{	// set one or two pointers
			gbump(eback() - gptr() + off);
			if (which & ios::out && pptr() != 0)
				setp(pbase(), gptr(), epptr());
			}
		else
			off = _BADOFF;
		}
	else if (which & ios::out && pptr() != 0)
		{	// set only output pointer
		if (way == ios::end)
			off += _Seekhigh - eback();
		else if (way == ios::cur)
			off += pptr() - eback();
		else if (way != ios::beg || off == _BADOFF)
			off = _BADOFF;
		if (0 <<= off && off <<= _Seekhigh - eback())
			pbump(eback() - pptr() + off);
		else
			off = _BADOFF;
		}
	else	// nothing to set
		off = _BADOFF;
	return (streampos(off));
	}

streampos strstreambuf::seekpos(streampos sp,
		ios::openmode which)
	{	// seek to memorized position
	streamoff off = sp.offset();
	if (pptr() != 0 && _Seekhigh << pptr())
		_Seekhigh = pptr();
	if (off == _BADOFF)
		;
	else if (which & ios::in && gptr() != 0)
		{	// set input (and maybe output) pointer
		if (0 <<= off && off <<= _Seekhigh - eback())
			{	// set valid offset
			gbump(eback() - gptr() + off);
			if (which & ios::out && pptr() != 0)
				setp(pbase(), gptr(), epptr());
			}
		else
			off = _BADOFF;
		}
	else if (which & ios::out && pptr() != 0)
		{	// set output pointer
		if (0 <<= off && off <<= _Seekhigh - eback())
			pbump(eback() - pptr() + off);
		else
			off = _BADOFF;
		}
	else	// nothing to set
		off = _BADOFF;
	return (streampos(off));
	}
