
    /********************************************
    *
    *    file d:\cips\texture.c
    *
    *    Functions: This file contains
    *       main
    *
    *    Purpose:
    *       This file contains the main calling
    *       routine for texture subroutines.
    *
    *    External Calls:
    *       gin.c - get_image_name
    *       tiff.c - read_tiff_header
    *       txtrsubs.c - sigma
    *                    skewness
    *                    amean
    *                    adifference
    *                    hurst
    *                    compare
    *
    *    Modifications:
    *       12 August 1993 - created
    *
    ********************************************/

#include "cips.h"



short the_image[ROWS][COLS];
short out_image[ROWS][COLS];

main(argc, argv)
   int argc;
   char *argv[];
{

   char name[80], name2[80];
   int  count, i, ie, il, j, le, length, ll, size,
        t, type, v, width;


   struct   tiff_header_struct image_header;

   my_clear_text_screen();


   if(argc < 7){
    printf("\n\nNot enough parameters:");
    printf("\n");
    printf("\n   usage: texture in-file out-file type ");
    printf("threshold? threshold-value size");
    printf("\n   recall type: sigma      skewness");
    printf("\n                amean      adifference");
    printf("\n                hurst      compare");
    printf("\n   threshold?   1-threshold on");
    printf("\n                2-threshold off\n");
    printf("\n   usage for compare:");
    printf("\n   texture in-file out-file compare ");
    printf("line element size");
    exit(0);
   }

   strcpy(name, argv[1]);
   strcpy(name2, argv[2]);
   t    = atoi(argv[4]);
   v    = atoi(argv[5]);
   size = atoi(argv[6]);

   il = 1;
   ie = 1;
   ll = ROWS+1;
   le = COLS+1;

   read_tiff_header(name, &image_header);

   length = (ROWS-10 + image_header.image_length)/ROWS;
   width  = (COLS-10 +image_header.image_width)/COLS;
   count  = 1;
   printf("\nlength=%d  width=%d", length, width);

   for(i=0; i<length; i++){
      for(j=0; j<width; j++){

        printf("\nrunning %d of %d", 
                count, length*width);
        count++;

        if(strncmp(argv[3], "compare", 3) == 0)
           compare(name, name2, the_image, out_image,
                   il+i*ROWS, ie+j*COLS,
                   ll+i*ROWS, le+j*COLS,
                   t, v, size);

        if(strncmp(argv[3], "hurst", 3) == 0)
           hurst(name, name2, the_image, out_image,
                 il+i*ROWS, ie+j*COLS,
                 ll+i*ROWS, le+j*COLS, size);

        if(strncmp(argv[3], "adifference", 3) == 0)
           adifference(name, name2, the_image, 
                       out_image, il+i*ROWS, 
                       ie+j*COLS, ll+i*ROWS,
                       le+j*COLS, size);

        if(strncmp(argv[3], "amean", 3) == 0)
           amean(name, name2, the_image, out_image,
                 il+i*ROWS, ie+j*COLS, ll+i*ROWS,
                 le+j*COLS, size);

        if(strncmp(argv[3], "skewness", 3) == 0)
           skewness(name, name2, the_image, out_image,
                    il+i*ROWS, ie+j*COLS, ll+i*ROWS,
                    le+j*COLS, size, t, v);

        if(strncmp(argv[3], "sigma", 3) == 0)
           sigma(name, name2, the_image, out_image,
                 il+i*ROWS, ie+j*COLS, ll+i*ROWS,
                 le+j*COLS, size, t, v);

      }
   }

}  /* ends main  */