
   /***********************************************
   *
   *   file d:\cips\side.c
   *
   *   Functions: This file contains
   *      main
   *
   *   Purpose:
   *      This file contains the main calling
   *      routine for a program which
   *      takes two images and pastes them
   *      together side by side or top to bottom
   *      into a new image file.
   *
   *      There are three files: two input files
   *      (file and file2), and one output
   *      file (file3).
   *
   *   External Calls:
   *      gin.c - get_image_name
   *      numcvrt.c - get_integer
   *                  int_convert
   *      tiff.c - read_tiff_header
   *      wtiff.c - does_not_exist
   *                create_allocate_tiff_file
   *      cutp.c - cut_image_piece
   *               paste_image_piece
   *
   *   Modifications:
   *      19 April 1992 - created
   *
   *************************************************/

#include "cips.h"



short the_image[ROWS][COLS];
short out_image[ROWS][COLS];

main(argc, argv)
   int argc;
   char *argv[];
{

   char     method[80], name[80], name2[80], name3[80];
   int      a, b, count, il, ie, ll, le,
            il2, ie2, ll2, le2,
            il3, ie3, ll3, le3,
            length, length2, length3,
            width, width2, width3;
   struct   tiff_header_struct image_header,
                               image_header2,
                               image_header3;

   my_clear_text_screen();

       /******************************************
       *
       *  Interpret the command line parameters.
       *
       *******************************************/

   if(argc < 5 || argc > 5){
    printf(
     "\n"
     "\n usage: side in-file-1 in-file-2 "
     "out-file method"
     "\n        where method is Top-to-bottom "
     "or Side-by-side"
     "\n");
    exit(0);
   }

   strcpy(name,   argv[1]);
   strcpy(name2,  argv[2]);
   strcpy(name3,  argv[3]);
   strcpy(method, argv[4]);

   if(does_not_exist(name)){
      printf("\nERROR: Input file %s does not exist", 
             name);
      printf(
       "\n"
       "\n usage: side in-file-1 in-file-2 "
       "out-file method"
       "\n        where method is Top-to-bottom "
       "or Side-by-side"
       "\n");
      exit(2);
   }

   if(does_not_exist(name2)){
      printf("\nERROR: Input file %s does not exist", 
             name2);
      printf(
       "\n"
       "\n usage: side in-file-1 in-file-2 "
       "out-file method"
       "\n        where method is Top-to-bottom "
       "or Side-by-side"
       "\n");
      exit(3);
   }

   if(method[0] != 't'   &&
      method[0] != 'T'   &&
      method[0] != 's'   &&
      method[0] != 'S'){
      printf("\nERROR: Did not choose a valid method");
      printf(
       "\n"
       "\n usage: side in-file-1 in-file-2 "
       "out-file method"
       "\n        where method is Top-to-bottom "
       "or Side-by-side"
       "\n");
      exit(4);
   }

       /*******************************************
       *
       *   Look at the headers of the two input
       *   files.  The output file will hold
       *   most of the two inputs.
       *
       *   Allocate the output file to hold both
       *   input files no matter which is larger
       *   in either dimension.
       *
       ********************************************/

   read_tiff_header(name, &image_header);
   round_off_image_size(&image_header,
                        &length, &width);
   read_tiff_header(name2, &image_header2);
   round_off_image_size(&image_header2,
                        &length2, &width2);

   if(method[0] == 'T' || method[0] == 't'){
      length3 = length + length2;
      width3  = width;
      if(width2 > width3) width3 = width2;
   }
   else{
      width3  = width + width2;
      length3 = length;
      if(length2 > length3) length3 = length2;
   }

   image_header3.image_length   = length3*ROWS;
   image_header3.image_width    = width3*COLS;
   image_header3.lsb            = 1;
   image_header3.bits_per_pixel = 8;
   image_header3.strip_offset   = 1000;
   create_allocate_tiff_file(name3, &image_header3,
                             out_image);

       /********************************************
       *
       *   Loop through the two input images.  Cut
       *   each image array from them and paste the
       *   arrays into the output image.  Paste the
       *   second input image to the left of the
       *   first for the side by side option and
       *   the second image below the first for the
       *   top to bottom option.
       *
       *********************************************/


       /*******************************************
       *
       *   First do the side by side option.
       *
       *********************************************/

   if(method[0] == 'S' || method[0] == 's'){
      il    = 1;
      ie    = 1;
      ll    = 101;
      le    = 101;
      count = 1;

         /****************************************
         *
         *   Copy the first input file into the
         *   left side of the output file.
         *
         *****************************************/

      for(a=0; a<length; a++){
         for(b=0; b<width; b++){
            printf("\ncut and paste %d of %d",
                     count++, length*width);
            cut_image_piece(name, the_image,
                            il+a*ROWS, ie+b*COLS,
                            ll+a*ROWS, le+b*COLS);
            paste_image_piece(name3, name, the_image, 
                              out_image,
                              il+a*ROWS, ie+b*COLS,
                              ll+a*ROWS, le+b*COLS);
         }  /* ends loop over b */
      }  /* ends loop over a */

      il2   = 1;
      ie2   = 1;
      ll2   = 101;
      le2   = 101;
      il3   = 1;
      ie3   = 1+COLS*width;
      ll3   = 101;
      le3   = 101+COLS*width;
      count = 1;


         /****************************************
         *
         *   Copy the second input file into the
         *   right side of the output file.
         *
         *****************************************/

      for(a=0; a<length2; a++){
         for(b=0; b<width2; b++){
            printf("\ncut and paste %d of %d",
                     count++, length2*width2);
            cut_image_piece(name2, the_image,
                            il2+a*ROWS, ie2+b*COLS,
                            ll2+a*ROWS, le2+b*COLS);
            paste_image_piece(name3, name, the_image, 
                              out_image,
                              il3+a*ROWS, ie3+b*COLS,
                              ll3+a*ROWS, le3+b*COLS);
         }  /* ends loop over b */
      }  /* ends loop over a */
   }  /* ends if side-by-side method */


       /********************************************
       *
       *   Now do the top to bottom option.
       *
       *********************************************/

   if(method[0] == 'T' || method[0] == 't'){
      il    = 1;
      ie    = 1;
      ll    = 101;
      le    = 101;
      count = 1;

         /****************************************
         *
         *   Copy the first input file into the
         *   top half of the output file.
         *
         *****************************************/

      for(a=0; a<length; a++){
         for(b=0; b<width; b++){
            printf("\ncut and paste %d of %d",
                     count++, length*width);
            cut_image_piece(name, the_image,
                            il+a*ROWS, ie+b*COLS,
                            ll+a*ROWS, le+b*COLS);
            paste_image_piece(name3, name, the_image, 
                              out_image,
                              il+a*ROWS, ie+b*COLS,
                              ll+a*ROWS, le+b*COLS);
         }  /* ends loop over b */
      }  /* ends loop over a */

      il2   = 1;
      ie2   = 1;
      ll2   = 101;
      le2   = 101;
      il3   = 1 + length * ROWS;
      ie3   = 1;
      ll3   = 101 + length * ROWS;
      le3   = 101;
      count = 1;

         /****************************************
         *
         *   Copy the second input file into the
         *   bottom half of the output file.
         *
         *****************************************/

      for(a=0; a<length2; a++){
         for(b=0; b<width2; b++){
            printf("\ncut and paste %d of %d",
                     count++, length2*width2);
            cut_image_piece(name2, the_image,
                            il2+a*ROWS, ie2+b*COLS,
                            ll2+a*ROWS, le2+b*COLS);
            paste_image_piece(name3, name, the_image, 
                              out_image,
                              il3+a*ROWS, ie3+b*COLS,
                              ll3+a*ROWS, le3+b*COLS);
         }  /* ends loop over b */
      }  /* ends loop over a */
   }  /* ends top-to-bottom method */

}  /* ends main */
