
   /***********************************************
   *
   *   file d:\cips\invert.c
   *
   *   Functions: This file contains
   *      main
   *
   *   Purpose:
   *      This program takes an image file and
   *      inverts it. It works with 8 bit images
   *      only.
   *
   *   External Calls:
   *      tiff.c - read_tiff_header
   *      rtiff.c - read_tiff_image
   *      wtiff.c - create_allocate_tiff_file
   *                write_array_into_tiff_image
   *
   *   Modifications:
   *      6 March 1993 - created
   *
   ***********************************************/

#include "cips.h"



short the_image[ROWS][COLS];
short out_image[ROWS][COLS];

main(argc, argv)
   int argc;
   char *argv[];
{
   char     r[80], name1[80], name2[80];
   int      a, b, count, i, ie, il, j,
            le, length, ll,  width;
   struct   tiff_header_struct image_header;


   my_clear_text_screen();

   if(argc != 3){
      printf("\nusage: invert in-file out-file\n");
      exit(1);
   }

   strcpy(name1, argv[1]);
   strcpy(name2, argv[2]);

   il     = 1;
   ie     = 1;
   ll     = ROWS+1;
   le     = COLS+1;

   read_tiff_header(name1, &image_header);
   round_off_image_size(&image_header,
                        &length, &width);
   image_header.image_length = length*ROWS;
   image_header.image_width  = width*COLS;
   create_allocate_tiff_file(name2, &image_header,
                             out_image);

   count = 1;

   for(i=0; i<length; i++){
      for(j=0; j<width; j++){
         printf("\nRunning %d of %d", 
                count, length*width);
         count++;
         read_tiff_image(name1, the_image,
                         il + i*ROWS,
                         ie + j*COLS,
                         ll + i*ROWS,
                         le + j*COLS);

         for(a=0; a<ROWS; a++)
            for(b=0; b<COLS; b++)
               out_image[a][b] = 255-the_image[a][b];

         write_array_into_tiff_image(name2, out_image,
                                     il + i*ROWS,
                                     ie + j*COLS,
                                     ll + i*ROWS,
                                     le + j*COLS);
      }  /* ends loop over i */
   }  /* ends loop over j */
}  /* ends main */
