

   /************************************************
   *
   *       file d:\cips\create.c
   *
   *       Functions: This file contains
   *           main
   *
   *       Purpose:
   *          This program creates an 8 bit tiff file
   *          of size l*ROWS by w*COLS.
   *
   *       External Calls:
   *          wtiff.c - create_allocate_tiff_file
   *
   *       Modifications:
   *          7 Arpil 1992 - created
   *
   *************************************************/

#include "cips.h"

short image[ROWS][COLS];

main(argc, argv)
   int  argc;
   char *argv[];
{
   int    l, w;
   struct tiff_header_struct image_header;

   if(argc < 4 || argc > 4){
      printf(
      "\nusage: create file-name length width\n"
      "\n       the program will multiply length "
      "and width"
      "\n       by %d and %d", ROWS, COLS);
      exit(-1);
   }

   l = atoi(argv[2]);
   w = atoi(argv[3]);

   image_header.lsb            = 1;
   image_header.bits_per_pixel = 8;
   image_header.image_length   = l*ROWS;
   image_header.image_width    = w*COLS;;
   image_header.strip_offset   = 1000;

   create_allocate_tiff_file(argv[1], 
                             &image_header, 
                             image);

}
