/*--------------------------------------------------------*
 * Simple program to test hashing.
 *
 * Problem: Read a list of words from stdin, count the
 *          frequency of each word and each letter.
 *--------------------------------------------------------*/

#include <iostream.h>
#include <iomanip.h>
#include <cstring.h>
#include "hashmap.h"

static unsigned
hash_str(const string &str)
{
    return str.hash();
}


static unsigned
hash_char(const char &theChar)
{
    return theChar;
}


static void
print_word(const string &word,
           int &count,
           void *out)
{
    (* (ostream *) out) << word << '\t' << count << endl;
}


static void
print_char(const char &ch, int &count, void *out)
{
    (* (ostream *) out) << ch << '\t' << count << endl;
}



int
main(int, char **)
{
    Map<string, int>  words(hash_str, 0);
    Map<char, int>    letters(hash_char, 0);

    string str;

    while (cin >> str) {
        ++words[str];
        for (int i = 0; i < str.length(); ++i)
            ++letters[str[i]];
    }

    cout << "\t\tWords:" << endl << endl;
    words.apply(print_word, &cout);
    cout << endl;

    cout << "\t\tLetters:" << endl << endl;
    letters.apply(print_char, &cout);
    cout << endl;

    return 0;
}
