/* ************************************ */
/* Include file for Net Bios Interface  */

typedef void (far *FARPROC)() ;
typedef void (*PROC)() ;

#define NETTIMEOUTERR 0x30   // Unused error code

/* Network control block structure */
struct Ncb {
	unsigned char	NCB_command;	// NCB COMMAND FIELD
	unsigned char	NCB_retcode;	// NCB RETURN CODE
	unsigned char	NCB_lsn;	// NCB LOCAL SESSION NUMBER
	unsigned char	NCB_num;	// NCB ALIAS NUMBER
	void far *	NCB_buffer; 	// NCB POINTER TO MESSAGE BUFFER
	unsigned int	NCB_length;	// NCB LENGTH (IN unsigned charS)
	unsigned char	NCB_callname[16];	// NCB NAME ON REMOTE ATTACHMENT
	unsigned char	NCB_name[16];    // NCB ALIAS NAME
	unsigned char	NCB_rto;	// NCB RECEIVE TIMEOUT
	unsigned char	NCB_sto;	// NCB SEND TIMEOUT
	FARPROC NCB_post;		// NCB POINTER TO POST ROUTINE
	unsigned char	NCB_lana_num;	// NCB ATTACHMENT #1 FOR SECOND ATTACHMENT
	unsigned char	NCB_cmd_cplt;	// COMMAND PENDING INDICATION
	unsigned char	NCB_reserve[14];    	// NCB RESERVED AREA
};

/* Net name descriptor */
struct netrpcserver {
       char *name ;			// Server network name
       int id ;                         // Server name id
       int replysize ;			// Size of reply structure in bytes
       unsigned int errcnt ;		// Number of network errors while in use
       unsigned int last_dgstat ;	// Last error value
       struct Ncb *receivencbptr ;      // Pointer to receive NCB
       struct Ncb *sendncbptr ;		// Pointer to send NCB
       void *dgbufin ;			// Pointer to input buffer
       void *(*rpc)(void *) ;           // Pointer to remote procedure
       struct netrpcserver *prev ;      // Link
       } ;

#define NCBNO_WAIT	0x0080	        // Flag for 'no wait' commands

	//
	//	NetBIOS command code definitions.
	//
	//	OR these command codes with NCBNO_WAIT for command
	//	with no wait.
	//

#define	NCBRESET		0x0032	// Reset local attachment
#define NCBSTATUS		0x0033	// Receive status of sessions
#define NCBCANCEL		0x0035	// Cancel request
#define NCBADDNAME		0x0030	// Add unique name
#define NCBADDGROUPNAME 	0x0036	// Add group name
#define NCBDELETENAME		0x0031  // Delete name
#define NCBCALL 		0x0010  // Open session
#define NCBLISTEN		0x0011  // Listen for a call
#define NCBHANGUP		0x0012  // End a session
#define NCBSEND 		0x0014  // Send
#define NCBSENDMULTIPLE 	0x0017  // Send multiple
#define NCBRECEIVE		0x0015  // Receive
#define NCBRECEIVEANY		0x0016  // Receive from any
#define NCBSESSIONSTATUS   	0x0034  // Session status
#define NCBSENDDATAGRAM 	0x0020  // Send a datagram
#define NCBRECEIVEDATAGRAM 	0x0021  // Receive a datagram
#define NCBSENDBROADCAST 	0x0022  // Send a broadcast datagram
#define NCBRECEIVEBROADCAST  	0x0023 	// Receive a broadcast datagram
#define NCBINVALID		0x007f	// An invalid NCB command

/* Datagram max size */
#define DGRAMSIZE 512
/* Structure to set buffer size */
struct dgbufsize {
       char buf[DGRAMSIZE] ; } ;
       
/* Function Prototypes */
net_name_command(int, char *, PROC, struct Ncb *) ;
net_dgram_command(int, int, char *, void *, int, FARPROC, struct Ncb *) ;
net_command_cancel(struct Ncb *, struct Ncb *) ;
char *ret_ncb_callname(char *, struct Ncb *) ;
struct netrpcserver *install_rpcserver(char *, void *(*)(void *), int) ;
void remove_all_rpcservers(void) ;
net_transact(char *, void *, int, void *, int) ;
open_net_client(char *) ;
close_net_client(void) ;
void net_comms() ;

/* Name macros take a name and a Ncb.
   Defaults to wait mode, no post function. */
#define NetAddName(a,b) net_name_command(NCBADDNAME,a,NULL,&(b))
#define NetDelName(a,b) net_name_command(NCBDELETENAME,a,NULL,&(b))
#define NetDelName_p(a,b) net_name_command(NCBDELETENAME,a,NULL,(b))

/* Transaction macro*/
#define NetTransact(b,c,d) net_transact((b),&(c),sizeof(c),&(d),sizeof(d))
