// LDIST2.C - Test program for LDIST.C module
//
// Tests the is_alike() function with two words passed on the command line.
//
// Written initailly by R. Bruce Roberts, MCI Systems Engineering, 1/7/93
// Compiled with Borland C++, V3.1
//
//---------------------------------------------------------------------------
// Revision History:
//
// Date     Ini   Comments
// -------- ---   ---------------
// 01/08/93 RBR   Test program initially created and tested.
// 08/30/94 RBR   Header modified for forwarding to CUJ
//
//---------------------------------------------------------------------------
#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "ldist.h"

//---------------------------------------------------------------------------
void main(int argc, char **argv)
{
   int ldist, threshold, rc;

   printf("Returns 'Levenstein Distance' of two strings on command line.\n");
   if (argc < 3)
   {
      printf("Error, not enough arguments\n");
      printf("Usage: LDIST2 str1 str2\n\n");
      exit(1);
   }

   printf("Determining Distance for %s and %s.\n", argv[1], argv[2]);
   printf("Length is limited to %d characters.\n", MAX_LDIST_LEN);
   rc = is_alike(argv[1], argv[2], &threshold, &ldist);
   printf("Words are %salike, L Distance is %d, Threshold was %d.\n",
      (rc) ? "" : "not ", ldist, threshold);
   exit(0);
}



