Listing 5.

counting_failure_handler::
        counting_failure_handler(void)
{
    /* install ourselves as the current handler */
    /* when we are created. */

    error_logged = warn_logged = 0L;
    prev_handler = err_mgr.define_handler(this);
}

counting_failure_handler::
        ~counting_failure_handler(void)
{
    /* unlink ourselves from the handler chain */
    /* when we are destroyed. */

    failure_handler *top = err_mgr.restore_handler();
    /* no other handler should be stacked over us! */
    ASSERT(top == this);
}

void counting_failure_handler::error(const char *fmt,
                                     va_list ap)
{
    ++error_logged;              /* tally problems */
    prev_handler->error(fmt,ap); /* pass message on */
}
