LISTING 13 - Shows that declarations are statements

// declare.cpp
#include <iostream.h>

main()
{
    int a[] = {0,1,2,3,4};

    // Print address and size
    cout << "a == " << (void *) a << endl;
    cout << "sizeof(a) == " << sizeof(a) << endl;

    // Print forwards
    size_t n = sizeof a / sizeof a[0];
    for (int i = 0; i < n; ++i)
        cout << a[i] << ' ';
    cout << endl;

    // Then backwards
    for (i = n-1; i >= 0; --i)
        cout << a[i] << ' ';
    cout << endl;
    return 0;
}

// Output:
a == 0xffec
sizeof(a) == 10
0 1 2 3 4 
4 3 2 1 0 

