/* File:     tutils.h
   Copyright Norman Wilde 1993
   Notes:    Header for utility functions for building test drivers.
	     In general, the generated "test driver" is a c++ file (stdout)
	     created from a test file (stdin). The test driver consists of:
	       - "embedded blocks" copied from the test file
	       - function definitions, one to set
		       each variable in each input "runtest" statement plus
		       a bottom level function to call the code being tested.
	       - a main program that calls the top function from
		       each runtest statement.
	     When compiled and executed, the test driver will cycle thru
	     one set of tests for each runtest statement.
*/
/* ----------- buffer for strings, blocks, etc. ------------- */
  void collect(char c);             /* collect char c into the buffer */
  void collectFirst(char c);        /* reset buf and collect c */
  char * release();                 /* copy the string in the buf to the 
                                    /* heap, terminate, and return the copy.*/
/* ----------- simple linked list of strings with data---------------- */
  struct STRLIST {
    char * str;
    void * data;
    struct STRLIST * next;
    };
  struct STRLIST * listNew(char* aStr, void * aData);
    /* Answer a new list with aStr as only element */
  struct STRLIST * listAdd(struct STRLIST * aList,char* aStr, void * aData);
    /* Add aStr to aList */
  void * listFind(struct STRLIST * aList, char * aStr);
    /* Locate string matching aStr in aList. Answer the data ptr. if
       found, NULL if not found */
  int listSize(struct STRLIST *aList);
    /* Answer the number of elements in the list */

/* --- routines to create the test driver program ------- */
  void addBlock(char * block);
   /* add to the driver the given embedded block */
  void setRunName(char * theRName);
   /* set the name of the test run to the first 20 chars of theRName*/
  void makeVary(struct STRLIST * varList, char * block);
   /* add to the driver the code for a "runtest ... varying ..." stmt. */
  void makeComb(struct STRLIST * varList, char * block);
   /* add to the driver the code for a "runtest ... combining ..." stmt. */
  void writeDriver(void);
   /* write the main function of the driver to standard output */

/* --- routines to manage a table of all the variables in a test file --- */
  struct VARIABLE {         /* each variable has a set of values */
    char * name;            /* string with name of the variable */
    char * dtype;           /* string with type for use in declarations */
    char * atype;           /* string with type for use in argument list */
    struct STRLIST * inits; /* list of initializers, one for each
			                         of the values of the variable */
  };
  void addVars(struct STRLIST * vList, char * typeStr, struct STRLIST * iList);
    /* Add to the table the variables in vList, each of which is
       of type typeStr (both for declarations and arguments)
       and has the set of initializors iList */
    /* NOTE - addVars is obsolete - should use addTVars that allows user
       to control if objects are passed by value or by reference */
  void addTVars(struct STRLIST * vList, char * decType, char * argType, struct STRLIST * iList);
    /* Add to the table the variables in vList, each of which is
       of type decType for declarations and type argType for arguments
       and has the set of initializors iList */
  char * getVarDecType(char * aVar);
    /* answer a string with the type of the variable, suitable for
       a C/C++ declaration */
  char * getVarArgType(char * aVar);
    /* answer a string with the type of the variable, suitable for
       a C/C++ function argument declaration */
  int getVarNumVals(char * aVar);
    /* answer the number of values in the set of initializors of
       aVar, or 0 if aVar is not found in the table */
  char * getVarDeclStr(char * aVar);
    /* answer a string with a c/c++ initialized declaration for
       aVar, using all the initializors of the variable */
