/* File:     Testgen.h
   Copyright Norman Wilde 1993
   Notes:
   The Test_gen class provides facilities for generating successively
   a series of integer vectors indicating
   the combinations of parameter values to be used in a test run
   The Test_gen_varying sub-class varies parameters one at a time,
    leaving the others at their default (zeroith) value.
   The Test_gen_combining sub-class generates all combinations of values.
   Parameters:
     num_params           is the number of parameters to be varied
			  and is the dimension of the vectors produced
			  0 < num_params
     max_vals[num_params] is the number of values of each parameter,
			  0 < max_vals[i] < 20
     test_vals[num_params] is the vector produced. If test_vals[2] = 3
                          then the parameter takes on its 4th value.
			  0 <= test_vals[i] < max_vals[i]
     Exceptions: If created or used with invalid values a warning is
     written to stdout and no further vectors are generated. The
     ok() member function may be used to check that a Test_gen is
     available for use.
*/
#include <iostream.h>        // to get ostream for the << operator
enum MORETESTS { NO, YES};
class Test_gen {
protected:
   int* max_vals; // array with number of values for each param
   int num_params; // number of params
public:
   Test_gen(int num_params, int max_val[]);
   ~Test_gen();
   MORETESTS next_vector(int test_vals[]);
   int ok(void);   // class invariant - use in assert statements
   friend ostream& operator<< (ostream& s, Test_gen& t);
      // output num_params and max_vals as text
};
class Test_gen_varying : public Test_gen {
   int param_to_vary; // parameter currently being varied, -1 at beginning
   int last_val; // last value of that parameter
public:
   Test_gen_varying(int num_params, int max_val[]);
   MORETESTS next_vector(int test_vals[]);
   int ok(void);
};
class Test_gen_combining : public Test_gen {
   int *last_val; // last values of all parameters
public:
   Test_gen_combining(int num_params, int max_val[]);
   ~Test_gen_combining();
   MORETESTS next_vector(int test_vals[]);
   int ok(void);
} ;
