/* File:     Testgen.cpp
   Copyright Norman Wilde 1993
*/
#include "testgen.h"
#include <iostream.h>
#include <assert.h>
Test_gen::Test_gen(int num_p, int max_v[]){
   num_params = num_p;
   max_vals = new int[num_params];
   for (int i = 0; i < num_params; i++)
	 max_vals[i] = max_v[i];
}
Test_gen::~Test_gen() {
//   cout << "DEBUG - Entering Test_gen::~Test_gen\n" ;
   delete max_vals;
}
MORETESTS Test_gen::next_vector(int test_vals[]) {
   cout << "Test_gen::next_vector : should be implemented by subclass\n";
   return NO;
}
ostream & operator<< (ostream& s, Test_gen& t) {
  // output num_params and max_vals as text to the stream
  s << "num_params = " << t.num_params << " max_vals = {";
  for (int i=0; i<t.num_params; i++)
     s << t.max_vals[i] << " ";
  s << "}";
  return s;
}
int Test_gen::ok(void) {
   if (num_params <1) return 0;
   for (int i=0; i<num_params; i++){
      if ((max_vals[i] <1) || (max_vals[i] > 19)) return 0;
   }
return 1;
}
Test_gen_varying::Test_gen_varying(int num_p, int max_v[]) :
	Test_gen( num_p, max_v) {
   param_to_vary = -1;
   last_val = 0;
   if (!ok())
      cout << "Error at " << __FILE__ << " l:" << __LINE__ << "\n" ;

}
MORETESTS Test_gen_varying::next_vector(int test_vals[]) {
   if(!ok()) return NO;
   for(int i= 0; i <num_params; i++) test_vals[i] = 0;
   if(param_to_vary == -1) { // first call - return 0,0,...
      param_to_vary = 0;
      last_val = 0;
      return YES;
   }
   assert( param_to_vary < num_params);
   assert( last_val < max_vals[param_to_vary] );
   // assert( all params <param_to_vary have been given all their vals)
   // assert( last value of param_to_vary was last_val )
   if(++last_val == max_vals[param_to_vary]) {
      // have reached maximum - find next param to vary
      last_val = 1; 
      while (++param_to_vary < num_params) {
	 if( max_vals[param_to_vary] > 1) break;
      }
   }
   if(param_to_vary < num_params) { // set value of param being varied
      test_vals[param_to_vary] = last_val;
      return YES;
   }
   else return NO;
}
Test_gen_varying::ok(void) {
   if( !(Test_gen::ok()) ) return 0;
   if( param_to_vary >= num_params ) return 0;
   return 1;
}
Test_gen_combining::Test_gen_combining(int num_p, int max_v[]) :
	Test_gen( num_p, max_v) {
   last_val = new int[num_p];
   last_val[0] = -1;
   for (int i=1; i< num_p; i++) last_val[i] = 0;
   if (!ok())
      cout << "Error at " << __FILE__ << " l:" << __LINE__ << "\n" ;

}
Test_gen_combining::~Test_gen_combining() {
   delete last_val;
}
MORETESTS Test_gen_combining::next_vector(int test_vals[]) {
   if( !ok() ) return NO;
   for( int p= 0; p< num_params; p++) {
      if(++(last_val[p]) < max_vals[p]) {
	 for(int j=0; j< p; j++) last_val[j] = 0;
	 for(int k=0; k<num_params; k++) test_vals[k] = last_val[k];
	 return YES;
      }
   }
   return NO;
}
int Test_gen_combining::ok(void) {
   if( !(Test_gen::ok()) ) return 0;
   for(int i=0; i<num_params; i++) {
     if ( last_val[i] >= max_vals[i]) return 0;
   }
   return 1;
}
