// File: invoice.h
// Copyright   Norman Wilde 1993
// Header for classes used in an Invoice
#include <iostream.h>
enum ClientType {RETAIL, WHOLESALE, FOREIGN};
class Item {
  long     prodCode;
  long     quant;
  float    basePrice;
  friend   ostream& operator << (ostream& s, Item& i);
 public:
  Item(long aCode, long aQuant, float aPrice );
  float value();
  long code();
};
class ItemList {
  Item * theItem;
  ItemList *nextItem;
 public:
  ItemList(Item *anItem );
  void addItem(Item *anItem );
  Item * currentItem();
  ItemList * next();
  ~ItemList();
};
class Client {
  ClientType cType;
  friend ostream& operator << (ostream& s, Client& c);
 public:
  Client(ClientType aClientType);
  ClientType type();
};
class Invoice {
  Client   *iClient;
  ItemList *iList;
  friend ostream& operator << (ostream&s, Invoice& i);
 public:
  Invoice(Client *aClient);
  void addItem(Item *anItem);
  float totalDiscount();
};
