#ifndef DGEN_H
#define DGEN_H

void init_dgen(void);
void dgen(void);
typedef union {
  char ag_vt_2[sizeof(int)];
  char ag_vt_3[sizeof(char *)];
  char ag_vt_4[sizeof(struct STRLIST *)];
} dgen_vs_type;

typedef enum {
  dgen_space_token = 1, dgen_blank_token, dgen_eol_token,
  dgen_comment_token, dgen_commentCharacter_token = 6,
  dgen_variable_token = 9, dgen_varStart_token, dgen_varRest_token,
  dgen_alpha_token = 13, dgen_alphanumeric_token, dgen_string_token,
  dgen_doubleQuote_token, dgen_stringContents_token,
  dgen_stringCharacter_token, dgen_block_token, dgen_blockStart_token,
  dgen_blockComponent_token, dgen_blockCharacter_token = 26,
  dgen_nestedBlock_token, dgen_nestStart_token, dgen_initializerList_token,
  dgen_initializer_token, dgen_initializer_contents_token = 32,
  dgen_notCloseBracket_token = 36, dgen_grammar_token, dgen_statement_token,
  dgen_eof_token = 40, dgen_embeddedBlock_token, dgen_runStatement_token,
  dgen_declaration_token, dgen_runHeader_token, dgen_testSpec_token,
  dgen_variableList_token = 48, dgen_charDeclaration_token = 50,
  dgen_stringDeclaration_token, dgen_intDeclaration_token,
  dgen_doubleDeclaration_token, dgen_FILEDeclaration_token,
  dgen_intarr2Declaration_token, dgen_ItemDeclaration_token,
  dgen_ClientDeclaration_token, dgen_InvoiceDeclaration_token
} dgen_token_type;

typedef struct {
  dgen_token_type token_number, reduction_token, error_frame_token;
  int input_code;
  int input_value;
  int line, column;
  int ssx, sn, error_frame_ssx;
  int drt, dssx, dsn;
  int ss[32];
  dgen_vs_type vs[32];
  int bts[32], btsx;
  unsigned char * pointer;
  unsigned char * la_ptr;
  int lab[9], rx, fx;
  unsigned char *key_sp;
  int save_index, key_state;
  char *error_message;
  char read_flag;
  char exit_flag;
} dgen_pcb_type;

#ifndef PRULE_CONTEXT
#define PRULE_CONTEXT(pcb)  (&((pcb).cs[(pcb).ssx]))
#define PERROR_CONTEXT(pcb) ((pcb).cs[(pcb).error_frame_ssx])
#define PCONTEXT(pcb)       ((pcb).cs[(pcb).ssx])
#endif

#ifndef AG_RUNNING_CODE_CODE
/* PCB.exit_flag values */
#define AG_RUNNING_CODE         0
#define AG_SUCCESS_CODE         1
#define AG_SYNTAX_ERROR_CODE    2
#define AG_REDUCTION_ERROR_CODE 3
#define AG_STACK_ERROR_CODE     4
#define AG_SEMANTIC_ERROR_CODE  5
#endif

extern dgen_pcb_type dgen_pcb;
#endif

