untrusted comment: verify with openbsd-78-base.pub
RWS3/nvFmk4SWXtWJdW27vyn1u9oiFLuVOWnVfxAzTn0kUWPWjzCawumgliTqTShvy0hJ5M1tOVBrrVaJCYvrX3DMaiBbmVwwQ8=

OpenBSD 7.8 errata 005, October 31, 2025:

smtpd(8) can die if a malformed imsg is sent on the local socket.
CVE-2025-62875

Apply by doing:
    signify -Vep /etc/signify/openbsd-78-base.pub -x 005_smtpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install smtpd
    cd /usr/src/usr.sbin/smtpd
    make obj
    make
    make install

Index: usr.sbin/smtpd/mproc.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/mproc.c,v
diff -u -p -u -r1.47 mproc.c
--- usr.sbin/smtpd/mproc.c	21 Nov 2024 13:42:22 -0000	1.47
+++ usr.sbin/smtpd/mproc.c	28 Oct 2025 15:22:04 -0000
@@ -144,6 +144,14 @@ mproc_dispatch(int fd, short event, void
 
 		switch (n) {
 		case -1:
+			if (smtpd_process == PROC_CONTROL &&
+			    p->proc == PROC_CLIENT) {
+				log_warnx("warn: client sent invalid imsg "
+				    "over control socket");
+				p->handler(p, NULL);
+				return;
+			}
+
 			log_warn("warn: %s -> %s: imsgbuf_read",
 			    proc_name(smtpd_process),  p->name);
 			fatal("exiting");
