/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XmlLangElement;
import org.jivesoftware.smack.packet.id.StandardStanzaIdSource;
import org.jivesoftware.smack.packet.id.StanzaIdSource;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.PacketUtil;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.XmppElementUtil;
import org.jxmpp.jid.Jid;

public abstract class Stanza
implements StanzaView,
TopLevelStreamElement {
    public static final String TEXT = "text";
    public static final String ITEM = "item";
    protected static final String DEFAULT_LANGUAGE = Locale.getDefault().getLanguage().toLowerCase(Locale.US);
    private final MultiMap<QName, ExtensionElement> extensionElements;
    private final String namespace = "jabber:client";
    private final StanzaIdSource usedStanzaIdSource;
    private String id = null;
    private Jid to;
    private Jid from;
    private StanzaError error = null;
    protected String language;

    protected Stanza() {
        this.extensionElements = new MultiMap();
        this.usedStanzaIdSource = null;
        this.id = StandardStanzaIdSource.DEFAULT.getNewStanzaId();
    }

    protected Stanza(StanzaBuilder<?> stanzaBuilder) {
        if (stanzaBuilder.stanzaIdSource != null) {
            this.id = stanzaBuilder.stanzaIdSource.getNewStanzaId();
            assert (StringUtils.isNullOrNotEmpty(this.id));
            this.usedStanzaIdSource = stanzaBuilder.stanzaIdSource;
        } else {
            this.id = stanzaBuilder.stanzaId;
            this.usedStanzaIdSource = null;
        }
        this.to = stanzaBuilder.to;
        this.from = stanzaBuilder.from;
        this.error = stanzaBuilder.stanzaError;
        this.language = stanzaBuilder.language;
        this.extensionElements = stanzaBuilder.extensionElements.clone();
    }

    protected Stanza(Stanza p) {
        this.usedStanzaIdSource = p.usedStanzaIdSource;
        this.id = p.getStanzaId();
        this.to = p.getTo();
        this.from = p.getFrom();
        this.error = p.error;
        this.extensionElements = p.extensionElements.clone();
    }

    @Override
    public final String getStanzaId() {
        return this.id;
    }

    public void setStanzaId(String id) {
        if (id != null) {
            StringUtils.requireNotNullNorEmpty(id, "id must either be null or not the empty String");
        }
        this.id = id;
    }

    public final boolean hasStanzaIdSet() {
        return this.id != null;
    }

    @Deprecated
    public String setStanzaId() {
        if (!this.hasStanzaIdSet()) {
            this.setNewStanzaId();
        }
        return this.getStanzaId();
    }

    public final void throwIfNoStanzaId() {
        if (this.hasStanzaIdSet()) {
            return;
        }
        throw new IllegalArgumentException("The stanza has no RFC stanza ID set, although one is required");
    }

    protected String setNewStanzaId() {
        this.id = this.usedStanzaIdSource != null ? this.usedStanzaIdSource.getNewStanzaId() : StandardStanzaIdSource.DEFAULT.getNewStanzaId();
        return this.getStanzaId();
    }

    @Override
    public final Jid getTo() {
        return this.to;
    }

    public void setTo(Jid to) {
        this.to = to;
    }

    @Override
    public final Jid getFrom() {
        return this.from;
    }

    public void setFrom(Jid from) {
        this.from = from;
    }

    @Override
    public final StanzaError getError() {
        return this.error;
    }

    public void setError(StanzaError stanzaError) {
        this.error = stanzaError;
    }

    @Deprecated
    public void setError(StanzaError.Builder stanzaError) {
        this.setError(stanzaError.build());
    }

    @Override
    public final String getLanguage() {
        return this.language;
    }

    @Deprecated
    public void setLanguage(String language) {
        this.language = language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<ExtensionElement> getExtensions() {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.values();
        }
    }

    public final MultiMap<QName, ExtensionElement> getExtensionsMap() {
        return this.cloneExtensionsMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final MultiMap<QName, ExtensionElement> cloneExtensionsMap() {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.clone();
        }
    }

    public final List<ExtensionElement> getExtensions(String elementName, String namespace) {
        StringUtils.requireNotNullNorEmpty(elementName, "elementName must not be null nor empty");
        StringUtils.requireNotNullNorEmpty(namespace, "namespace must not be null nor empty");
        QName key = new QName(namespace, elementName);
        return this.getExtensions(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<ExtensionElement> getExtensions(QName qname) {
        List<ExtensionElement> res;
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            res = this.extensionElements.getAll(qname);
        }
        return Collections.unmodifiableList(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <E extends ExtensionElement> List<E> getExtensions(Class<E> extensionElementClass) {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return XmppElementUtil.getElementsFrom(this.extensionElements, extensionElementClass);
        }
    }

    public final ExtensionElement getExtension(String namespace) {
        return PacketUtil.extensionElementFrom(this.getExtensions(), null, namespace);
    }

    public final ExtensionElement getExtensionElement(String elementName, String namespace) {
        if (namespace == null) {
            return null;
        }
        QName key = new QName(namespace, elementName);
        ExtensionElement packetExtension = this.getExtension(key);
        if (packetExtension == null) {
            return null;
        }
        return packetExtension;
    }

    @Deprecated
    public final <E extends ExtensionElement> E getExtension(String elementName, String namespace) {
        return (E)this.getExtensionElement(elementName, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ExtensionElement getExtension(QName qname) {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.getFirst(qname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExtension(ExtensionElement extension) {
        if (extension == null) {
            return;
        }
        QName key = extension.getQName();
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            this.extensionElements.put(key, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExtensionElement overrideExtension(ExtensionElement extension) {
        if (extension == null) {
            return null;
        }
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            ExtensionElement removedExtension = this.removeExtension(extension.getElementName(), extension.getNamespace());
            this.addExtension(extension);
            return removedExtension;
        }
    }

    public final void addExtensions(Collection<? extends ExtensionElement> extensions) {
        if (extensions == null) {
            return;
        }
        for (ExtensionElement extensionElement : extensions) {
            this.addExtension(extensionElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasExtension(String elementName, String namespace) {
        if (elementName == null) {
            return this.hasExtension(namespace);
        }
        QName key = new QName(namespace, elementName);
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasExtension(String namespace) {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            for (ExtensionElement packetExtension : this.extensionElements.values()) {
                if (!packetExtension.getNamespace().equals(namespace)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExtensionElement removeExtension(String elementName, String namespace) {
        QName key = new QName(namespace, elementName);
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final ExtensionElement removeExtension(ExtensionElement extension) {
        QName key = extension.getQName();
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            List<ExtensionElement> list = this.extensionElements.getAll(key);
            boolean removed = list.remove(extension);
            if (removed) {
                return extension;
            }
        }
        return null;
    }

    public abstract String toString();

    @Override
    public final String getNamespace() {
        return "jabber:client";
    }

    public static String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    protected final void addCommonAttributes(XmlStringBuilder xml) {
        xml.optAttribute("to", (CharSequence)this.getTo());
        xml.optAttribute("from", (CharSequence)this.getFrom());
        xml.optAttribute("id", this.getStanzaId());
    }

    protected void logCommonAttributes(StringBuilder sb) {
        if (this.getTo() != null) {
            sb.append("to=").append((CharSequence)this.to).append(',');
        }
        if (this.getFrom() != null) {
            sb.append("from=").append((CharSequence)this.from).append(',');
        }
        if (this.hasStanzaIdSet()) {
            sb.append("id=").append(this.id).append(',');
        }
    }

    protected final void appendErrorIfExists(XmlStringBuilder xml) {
        StanzaError error = this.getError();
        if (error != null) {
            xml.append(error);
        }
    }

    static String determineLanguage(XmlLangElement xmlLangElement, String language) {
        if (language != null && !language.isEmpty()) {
            return language;
        }
        return xmlLangElement.getLanguage();
    }
}

