/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ir.SharedVariablesManager;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/JsSharedVariablesManager;", "Lorg/jetbrains/kotlin/backend/common/ir/SharedVariablesManager;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "createBox", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "dynamicType", "Lorg/jetbrains/kotlin/ir/types/IrDynamicType;", "readBox", "writeBox", "declareSharedVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "originalDeclaration", "defineSharedValue", "sharedVariableDeclaration", "getSharedValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "sharedVariableSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "originalGet", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "setSharedValue", "originalSet", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "backend.js"})
public final class JsSharedVariablesManager
implements SharedVariablesManager {
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final IrSimpleFunctionSymbol createBox;
    @NotNull
    private final IrSimpleFunctionSymbol readBox;
    @NotNull
    private final IrSimpleFunctionSymbol writeBox;
    @NotNull
    private final IrDynamicType dynamicType;

    public JsSharedVariablesManager(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.builtIns = context.getIrBuiltIns();
        this.createBox = context.getIntrinsics().getCreateSharedBox();
        this.readBox = context.getIntrinsics().getReadSharedBox();
        this.writeBox = context.getIntrinsics().getWriteSharedBox();
        this.dynamicType = context.getDynamicType();
    }

    @Override
    @NotNull
    public IrVariable declareSharedVariable(@NotNull IrVariable originalDeclaration) {
        Intrinsics.checkNotNullParameter((Object)originalDeclaration, (String)"originalDeclaration");
        IrType valueType = originalDeclaration.getType();
        IrExpression irExpression = originalDeclaration.getInitializer();
        if (irExpression == null) {
            irExpression = IrConstImpl.Companion.constNull(originalDeclaration.getStartOffset(), originalDeclaration.getEndOffset(), valueType);
        }
        IrExpression initializer2 = irExpression;
        int n = initializer2.getStartOffset();
        int n2 = initializer2.getEndOffset();
        IrDynamicType irDynamicType = this.dynamicType;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.createBox;
        IrElementBase irElementBase = new IrCallImpl(n, n2, irDynamicType, irSimpleFunctionSymbol, 1, 1, null, null, 192, null);
        IrCallImpl $this$declareSharedVariable_u24lambda_u240 = irElementBase;
        boolean bl = false;
        $this$declareSharedVariable_u24lambda_u240.putTypeArgument(0, valueType);
        $this$declareSharedVariable_u24lambda_u240.putValueArgument(0, initializer2);
        IrCallImpl irCall = irElementBase;
        IrElementBase it = irElementBase = DeclarationBuildersKt.buildVariable$default(originalDeclaration.getParent(), originalDeclaration.getStartOffset(), originalDeclaration.getEndOffset(), originalDeclaration.getOrigin(), originalDeclaration.getName(), this.dynamicType, false, false, false, 448, null);
        boolean bl2 = false;
        ((IrVariable)it).setInitializer(irCall);
        return irElementBase;
    }

    @Override
    @NotNull
    public IrVariable defineSharedValue(@NotNull IrVariable originalDeclaration, @NotNull IrVariable sharedVariableDeclaration) {
        Intrinsics.checkNotNullParameter((Object)originalDeclaration, (String)"originalDeclaration");
        Intrinsics.checkNotNullParameter((Object)sharedVariableDeclaration, (String)"sharedVariableDeclaration");
        return sharedVariableDeclaration;
    }

    @Override
    @NotNull
    public IrExpression getSharedValue(@NotNull IrValueSymbol sharedVariableSymbol, @NotNull IrGetValue originalGet) {
        IrCallImpl irCallImpl;
        Intrinsics.checkNotNullParameter((Object)sharedVariableSymbol, (String)"sharedVariableSymbol");
        Intrinsics.checkNotNullParameter((Object)originalGet, (String)"originalGet");
        IrCallImpl $this$getSharedValue_u24lambda_u242 = irCallImpl = new IrCallImpl(originalGet.getStartOffset(), originalGet.getEndOffset(), originalGet.getType(), this.readBox, 1, 1, originalGet.getOrigin(), null, 128, null);
        boolean bl = false;
        $this$getSharedValue_u24lambda_u242.putTypeArgument(0, originalGet.getType());
        $this$getSharedValue_u24lambda_u242.putValueArgument(0, new IrGetValueImpl(originalGet.getStartOffset(), originalGet.getEndOffset(), this.dynamicType, sharedVariableSymbol, originalGet.getOrigin()));
        return irCallImpl;
    }

    @Override
    @NotNull
    public IrExpression setSharedValue(@NotNull IrValueSymbol sharedVariableSymbol, @NotNull IrSetValue originalSet) {
        IrCallImpl irCallImpl;
        Intrinsics.checkNotNullParameter((Object)sharedVariableSymbol, (String)"sharedVariableSymbol");
        Intrinsics.checkNotNullParameter((Object)originalSet, (String)"originalSet");
        IrCallImpl $this$setSharedValue_u24lambda_u243 = irCallImpl = new IrCallImpl(originalSet.getStartOffset(), originalSet.getEndOffset(), this.builtIns.getUnitType(), this.writeBox, 1, 2, originalSet.getOrigin(), null, 128, null);
        boolean bl = false;
        $this$setSharedValue_u24lambda_u243.putTypeArgument(0, originalSet.getValue().getType());
        $this$setSharedValue_u24lambda_u243.putValueArgument(0, new IrGetValueImpl(originalSet.getStartOffset(), originalSet.getEndOffset(), this.dynamicType, sharedVariableSymbol, originalSet.getOrigin()));
        $this$setSharedValue_u24lambda_u243.putValueArgument(1, originalSet.getValue());
        return irCallImpl;
    }
}

