/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.util;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger LOG = LoggerFactory.getLogger(Version.class);

    private Version() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readVersion(ClassLoader cl, String path, String defaultVersion) {
        InputStream is;
        String version;
        block4: {
            version = defaultVersion;
            is = null;
            try {
                Properties props = new Properties();
                is = cl.getResourceAsStream(path);
                if (is == null) break block4;
                props.load(is);
                version = props.getProperty("version");
            }
            catch (IOException e) {
                try {
                    LOG.error("Could not load/read version from " + path, (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(is);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)is);
            }
        }
        Closeables.closeQuietly((Closeable)is);
        return version;
    }

    public static String readVersion(String path, String defaultVersion) {
        return Version.readVersion(Version.class.getClassLoader(), path, defaultVersion);
    }
}

