/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.client.core.spi.subsystem.repository.RepositoryFactory;
import org.sonatype.nexus.client.core.subsystem.repository.Repository;
import org.sonatype.nexus.client.core.subsystem.repository.VirtualRepository;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.JerseyVirtualRepository;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryBaseResource;
import org.sonatype.nexus.rest.model.RepositoryShadowResource;

@Named
@Singleton
public class JerseyVirtualRepositoryFactory
implements RepositoryFactory<VirtualRepository> {
    @Override
    public int canAdapt(RepositoryBaseResource resource) {
        int score = 0;
        if (resource instanceof RepositoryShadowResource) {
            ++score;
        }
        if ("virtual".equals(resource.getRepoType())) {
            ++score;
        }
        return score;
    }

    @Override
    public JerseyVirtualRepository adapt(JerseyNexusClient nexusClient, RepositoryBaseResource resource) {
        return new JerseyVirtualRepository(nexusClient, (RepositoryShadowResource)resource);
    }

    @Override
    public boolean canCreate(Class<? extends Repository> type) {
        return VirtualRepository.class.equals(type);
    }

    @Override
    public JerseyVirtualRepository create(JerseyNexusClient nexusClient, String id) {
        return new JerseyVirtualRepository(nexusClient, id);
    }
}

