/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geoloc.packet;

import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;

public final class GeoLocation
implements Serializable,
ExtensionElement,
FormFieldChildElement {
    private static final long serialVersionUID = 1L;
    public static final String NAMESPACE = "http://jabber.org/protocol/geoloc";
    public static final String ELEMENT = "geoloc";
    public static final QName QNAME = new QName("http://jabber.org/protocol/geoloc", "geoloc");
    public static final GeoLocation EMPTY_GEO_LOCATION = GeoLocation.builder().build();
    private final Double accuracy;
    private final Double alt;
    private final Double altAccuracy;
    private final String area;
    private final Double bearing;
    private final String building;
    private final String country;
    private final String countryCode;
    private final String datum;
    private final String description;
    private final Double error;
    private final String floor;
    private final Double lat;
    private final String locality;
    private final Double lon;
    private final String postalcode;
    private final String region;
    private final String room;
    private final Double speed;
    private final String street;
    private final String text;
    private final Date timestamp;
    private final String tzo;
    private final URI uri;
    private final HashCode.Cache hashCodeCache = new HashCode.Cache();

    private GeoLocation(Builder builder) {
        this.accuracy = builder.accuracy;
        this.alt = builder.alt;
        this.altAccuracy = builder.altAccuracy;
        this.area = builder.area;
        this.bearing = builder.bearing;
        this.building = builder.building;
        this.country = builder.country;
        this.countryCode = builder.countryCode;
        this.datum = builder.datum;
        this.description = builder.description;
        this.error = builder.error;
        this.floor = builder.floor;
        this.lat = builder.lat;
        this.locality = builder.locality;
        this.lon = builder.lon;
        this.postalcode = builder.postalcode;
        this.region = builder.region;
        this.room = builder.room;
        this.speed = builder.speed;
        this.street = builder.street;
        this.text = builder.text;
        this.timestamp = builder.timestamp;
        this.tzo = builder.tzo;
        this.uri = builder.uri;
    }

    public Double getAccuracy() {
        return this.accuracy;
    }

    public Double getAlt() {
        return this.alt;
    }

    public Double getAltAccuracy() {
        return this.altAccuracy;
    }

    public String getArea() {
        return this.area;
    }

    public Double getBearing() {
        return this.bearing;
    }

    public String getBuilding() {
        return this.building;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getDatum() {
        return this.datum;
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public Double getError() {
        return this.error;
    }

    public String getFloor() {
        return this.floor;
    }

    public Double getLat() {
        return this.lat;
    }

    public String getLocality() {
        return this.locality;
    }

    public Double getLon() {
        return this.lon;
    }

    public String getPostalcode() {
        return this.postalcode;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRoom() {
        return this.room;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public String getStreet() {
        return this.street;
    }

    public String getText() {
        return this.text;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getTzo() {
        return this.tzo;
    }

    public URI getUri() {
        return this.uri;
    }

    public QName getQName() {
        return QNAME;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public CharSequence toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this);
        xml.rightAngleBracket();
        xml.optElement("accuracy", (Object)this.accuracy);
        xml.optElement("alt", (Object)this.alt);
        xml.optElement("altaccuracy", (Object)this.altAccuracy);
        xml.optElement("area", this.area);
        xml.optElement("bearing", (Object)this.bearing);
        xml.optElement("building", this.building);
        xml.optElement("country", this.country);
        xml.optElement("countrycode", this.countryCode);
        xml.optElement("datum", this.datum);
        xml.optElement("description", this.description);
        xml.optElement("error", (Object)this.error);
        xml.optElement("floor", this.floor);
        xml.optElement("lat", (Object)this.lat);
        xml.optElement("locality", this.locality);
        xml.optElement("lon", (Object)this.lon);
        xml.optElement("postalcode", this.postalcode);
        xml.optElement("region", this.region);
        xml.optElement("room", this.room);
        xml.optElement("speed", (Object)this.speed);
        xml.optElement("street", this.street);
        xml.optElement("text", this.text);
        xml.optElement("timestamp", this.timestamp);
        xml.optElement("tzo", this.tzo);
        xml.optElement("uri", (Object)this.uri);
        xml.closeElement((NamedElement)this);
        return xml;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public int hashCode() {
        return this.hashCodeCache.getHashCode(c -> c.append((Object)this.accuracy).append((Object)this.alt).append((Object)this.altAccuracy).append((Object)this.area).append((Object)this.bearing).append((Object)this.building).append((Object)this.country).append((Object)this.countryCode).append((Object)this.datum).append((Object)this.description).append((Object)this.error).append((Object)this.floor).append((Object)this.lat).append((Object)this.locality).append((Object)this.lon).append((Object)this.postalcode).append((Object)this.region).append((Object)this.room).append((Object)this.speed).append((Object)this.street).append((Object)this.text).append((Object)this.timestamp).append((Object)this.tzo).append((Object)this.uri));
    }

    public boolean equals(Object obj) {
        return EqualsUtil.equals((Object)this, (Object)obj, (e, o) -> e.append((Object)this.accuracy, (Object)o.accuracy).append((Object)this.altAccuracy, (Object)o.altAccuracy).append((Object)this.area, (Object)o.area).append((Object)this.bearing, (Object)o.bearing).append((Object)this.building, (Object)o.building).append((Object)this.country, (Object)o.country).append((Object)this.countryCode, (Object)o.countryCode).append((Object)this.datum, (Object)o.datum).append((Object)this.description, (Object)o.description).append((Object)this.error, (Object)o.error).append((Object)this.floor, (Object)o.floor).append((Object)this.lat, (Object)o.lat).append((Object)this.locality, (Object)o.locality).append((Object)this.lon, (Object)o.lon).append((Object)this.postalcode, (Object)o.postalcode).append((Object)this.region, (Object)o.region).append((Object)this.room, (Object)o.room).append((Object)this.speed, (Object)o.speed).append((Object)this.street, (Object)o.street).append((Object)this.text, (Object)o.text).append((Object)this.timestamp, (Object)o.timestamp).append((Object)this.tzo, (Object)o.tzo).append((Object)this.uri, (Object)o.uri));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isExclusiveElement() {
        return true;
    }

    public static GeoLocation from(Message message) {
        return (GeoLocation)message.getExtension(GeoLocation.class);
    }

    public static GeoLocation from(FormField formField) {
        return (GeoLocation)formField.getFormFieldChildElement(QNAME);
    }

    public static class Builder {
        private Double accuracy;
        private Double alt;
        private Double altAccuracy;
        private String area;
        private Double bearing;
        private String building;
        private String country;
        private String countryCode;
        private String datum = "WGS84";
        private String description;
        private Double error;
        private String floor;
        private Double lat;
        private String locality;
        private Double lon;
        private String postalcode;
        private String region;
        private String room;
        private Double speed;
        private String street;
        private String text;
        private Date timestamp;
        private String tzo;
        private URI uri;

        public Builder setAccuracy(Double accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public Builder setAlt(Double alt) {
            this.alt = alt;
            return this;
        }

        public Builder setAltAccuracy(Double altAccuracy) {
            this.altAccuracy = altAccuracy;
            return this;
        }

        public Builder setArea(String area) {
            this.area = area;
            return this;
        }

        public Builder setBearing(Double bearing) {
            this.bearing = bearing;
            return this;
        }

        public Builder setBuilding(String building) {
            this.building = building;
            return this;
        }

        public Builder setCountry(String country) {
            this.country = country;
            return this;
        }

        public Builder setCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder setDatum(String datum) {
            this.datum = datum;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Deprecated
        public Builder setError(Double error) {
            this.error = error;
            return this;
        }

        public Builder setFloor(String floor) {
            this.floor = floor;
            return this;
        }

        public Builder setLat(Double lat) {
            this.lat = lat;
            return this;
        }

        public Builder setLocality(String locality) {
            this.locality = locality;
            return this;
        }

        public Builder setLon(Double lon) {
            this.lon = lon;
            return this;
        }

        public Builder setPostalcode(String postalcode) {
            this.postalcode = postalcode;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setRoom(String room) {
            this.room = room;
            return this;
        }

        public Builder setSpeed(Double speed) {
            this.speed = speed;
            return this;
        }

        public Builder setStreet(String street) {
            this.street = street;
            return this;
        }

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setTzo(String tzo) {
            this.tzo = tzo;
            return this;
        }

        public Builder setUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public GeoLocation build() {
            return new GeoLocation(this);
        }
    }
}

