/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.IOUtil;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;

public class PomPropertiesUtil {
    private static final String GENERATED_BY_MAVEN = "Generated by Apache Maven";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sameContents(Properties props, File file) throws IOException {
        boolean bl;
        if (!file.isFile()) {
            return false;
        }
        Properties fileProps = new Properties();
        FileInputStream istream = null;
        try {
            istream = new FileInputStream(file);
            fileProps.load(istream);
            ((InputStream)istream).close();
            istream = null;
            bl = fileProps.equals(props);
        }
        catch (IOException e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtil.close(istream);
                throw throwable;
            }
            IOUtil.close((InputStream)istream);
            return bl2;
        }
        IOUtil.close((InputStream)istream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPropertyFile(Properties properties, File outputFile, boolean forceCreation) throws IOException {
        File outputDir = outputFile.getParentFile();
        if (outputDir != null && !outputDir.isDirectory() && !outputDir.mkdirs()) {
            throw new IOException("Failed to create directory: " + outputDir);
        }
        if (!forceCreation && this.sameContents(properties, outputFile)) {
            return;
        }
        FileOutputStream os = new FileOutputStream(outputFile);
        try {
            properties.store(os, GENERATED_BY_MAVEN);
            ((OutputStream)os).close();
            os = null;
        }
        finally {
            IOUtil.close((OutputStream)os);
        }
    }

    public void createPomProperties(MavenProject project, Archiver archiver, File pomPropertiesFile, boolean forceCreation) throws ArchiverException, IOException {
        String artifactId = project.getArtifactId();
        String groupId = project.getGroupId();
        Properties p = new Properties();
        p.setProperty("groupId", project.getGroupId());
        p.setProperty("artifactId", project.getArtifactId());
        p.setProperty("version", project.getVersion());
        this.createPropertyFile(p, pomPropertiesFile, forceCreation);
        archiver.addFile(pomPropertiesFile, "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
    }
}

