/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.recording;

import io.mockk.CompositeMatcher;
import io.mockk.Matcher;
import io.mockk.MockKException;
import io.mockk.RecordedCall;
import io.mockk.impl.InternalPlatform;
import io.mockk.impl.log.Logger;
import io.mockk.impl.log.SafeToString;
import io.mockk.impl.recording.CallRound;
import io.mockk.impl.recording.ChainedCallDetector;
import io.mockk.impl.recording.SignedCall;
import io.mockk.impl.recording.SignedMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lio/mockk/impl/recording/SignatureMatcherDetector;", "", "safeToString", "Lio/mockk/impl/log/SafeToString;", "chainedCallDetectorFactory", "Lkotlin/Function0;", "Lio/mockk/impl/recording/ChainedCallDetector;", "Lio/mockk/impl/recording/ChainedCallDetectorFactory;", "(Lio/mockk/impl/log/SafeToString;Lkotlin/jvm/functions/Function0;)V", "calls", "", "Lio/mockk/RecordedCall;", "getCalls", "()Ljava/util/List;", "getChainedCallDetectorFactory", "()Lkotlin/jvm/functions/Function0;", "log", "Lio/mockk/impl/log/Logger;", "getLog", "()Lio/mockk/impl/log/Logger;", "detect", "", "callRounds", "", "Lio/mockk/impl/recording/CallRound;", "mockk"})
public final class SignatureMatcherDetector {
    @NotNull
    private final Function0<ChainedCallDetector> chainedCallDetectorFactory;
    @NotNull
    private final List<RecordedCall> calls;
    @NotNull
    private final Logger log;

    public SignatureMatcherDetector(@NotNull SafeToString safeToString2, @NotNull Function0<ChainedCallDetector> chainedCallDetectorFactory) {
        Intrinsics.checkNotNullParameter((Object)safeToString2, (String)"safeToString");
        Intrinsics.checkNotNullParameter(chainedCallDetectorFactory, (String)"chainedCallDetectorFactory");
        this.chainedCallDetectorFactory = chainedCallDetectorFactory;
        this.calls = new ArrayList();
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        this.log = safeToString2.invoke((Logger)this_$iv.getLoggerFactory().invoke((Object)Reflection.getOrCreateKotlinClass(SignatureMatcherDetector.class)));
    }

    @NotNull
    public final Function0<ChainedCallDetector> getChainedCallDetectorFactory() {
        return this.chainedCallDetectorFactory;
    }

    @NotNull
    public final List<RecordedCall> getCalls() {
        return this.calls;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    public final void detect(@NotNull List<CallRound> callRounds) {
        Intrinsics.checkNotNullParameter(callRounds, (String)"callRounds");
        this.calls.clear();
        int nCalls = callRounds.get(0).getCalls().size();
        int nMatchers = callRounds.get(0).getMatchers().size();
        HashMap matcherMap = new HashMap();
        List allCompositeMatchers = new ArrayList();
        SignatureMatcherDetector.detect$checkAllSameNumberOfCalls(callRounds, nCalls);
        SignatureMatcherDetector.detect$checkAllSameNumberOfMatchers(callRounds, nMatchers);
        SignatureMatcherDetector.detect$gatherMatchers(nMatchers, this, callRounds, allCompositeMatchers, matcherMap);
        int n = 0;
        while (n < nCalls) {
            int n2;
            int callN = n2 = n++;
            boolean bl = false;
            ChainedCallDetector detector = (ChainedCallDetector)this.getChainedCallDetectorFactory().invoke();
            detector.detect(callRounds, callN, matcherMap);
            this.getCalls().add(detector.getCall());
        }
        SignatureMatcherDetector.detect$processCompositeMatchers(allCompositeMatchers, this, matcherMap);
        if (!((Map)matcherMap).isEmpty()) {
            throw new MockKException("Failed matching mocking signature for\n" + CollectionsKt.joinToString$default((Iterable)callRounds.get(0).getCalls(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\nleft matchers: " + matcherMap.values(), null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void detect$checkAllSameNumberOfCalls(List<CallRound> $callRounds, int nCalls) {
        boolean bl;
        Iterable $this$any$iv;
        block6: {
            $this$any$iv = $callRounds;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CallRound it = (CallRound)element$iv;
                    boolean bl2 = false;
                    if (!(it.getCalls().size() != nCalls)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$any$iv = CollectionsKt.withIndex((Iterable)$callRounds);
            String string = "every/verify {} block were run several times. Recorded calls count differ between runs\n";
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void it;
                IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Iterable iterable = ((CallRound)it.getValue()).getCalls();
                StringBuilder stringBuilder = new StringBuilder().append("Round ").append(it.getIndex() + 1).append(": ");
                boolean $i$f$map2 = false;
                void var14_17 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it2;
                    SignedCall signedCall2 = (SignedCall)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl4 = false;
                    collection2.add(it2.getInvocationStr());
                }
                collection.add(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).toString());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            Throwable throwable = null;
            String string2 = Intrinsics.stringPlus((String)string, (Object)CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            throw new MockKException(string2, throwable, n, defaultConstructorMarker);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void detect$checkAllSameNumberOfMatchers(List<CallRound> $callRounds, int nMatchers) {
        boolean bl;
        Iterable $this$any$iv;
        block6: {
            $this$any$iv = $callRounds;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CallRound it = (CallRound)element$iv;
                    boolean bl2 = false;
                    if (!(it.getMatchers().size() != nMatchers)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$any$iv = CollectionsKt.withIndex((Iterable)$callRounds);
            String string = "every/verify {} block were run several times. Recorded matchers count differ between runs\n";
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void it;
                IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Iterable iterable = ((CallRound)it.getValue()).getMatchers();
                StringBuilder stringBuilder = new StringBuilder().append("Round ").append(it.getIndex() + 1).append(": ");
                boolean $i$f$map2 = false;
                void var14_17 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it2;
                    SignedMatcher signedMatcher = (SignedMatcher)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl4 = false;
                    collection2.add(it2);
                }
                collection.add(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).toString());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            Throwable throwable = null;
            String string2 = Intrinsics.stringPlus((String)string, (Object)CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            throw new MockKException(string2, throwable, n, defaultConstructorMarker);
        }
    }

    private static final void detect$gatherMatchers(int nMatchers, SignatureMatcherDetector this$0, List<CallRound> $callRounds, List<List<CompositeMatcher<?>>> allCompositeMatchers, HashMap<List<Object>, Matcher<?>> matcherMap) {
        int n = 0;
        while (n < nMatchers) {
            CallRound it;
            List<List<CompositeMatcher<?>>> list;
            Iterable $this$mapTo$iv$iv;
            int n2;
            int nMatcher = n2 = n++;
            boolean bl = false;
            Matcher<?> matcher2 = ((CallRound)CollectionsKt.last($callRounds)).getMatchers().get(nMatcher).getMatcher();
            Iterable $this$map$iv = $callRounds;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection<List<Object>> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CallRound callRound = (CallRound)item$iv$iv;
                list = destination$iv$iv;
                boolean bl2 = false;
                list.add((List<CompositeMatcher<?>>)it.getMatchers().get(nMatcher).getSignature());
            }
            List signature = (List)destination$iv$iv;
            if (matcher2 instanceof CompositeMatcher) {
                $this$map$iv = $callRounds;
                list = allCompositeMatchers;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (CallRound)item$iv$iv;
                    Collection<List<Object>> collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add((List<Object>)((CompositeMatcher)it.getMatchers().get(nMatcher).getMatcher()));
                }
                list.add((List<CompositeMatcher<?>>)destination$iv$iv);
            }
            ((Map)matcherMap).put(signature, matcher2);
        }
        this$0.log.trace((Function0<String>)((Function0)new Function0<String>(matcherMap){
            final /* synthetic */ HashMap<List<Object>, Matcher<?>> $matcherMap;
            {
                this.$matcherMap = $matcherMap;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"Matcher map: ", this.$matcherMap);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private static final void detect$processCompositeMatchers(List<List<CompositeMatcher<?>>> allCompositeMatchers, SignatureMatcherDetector this$0, HashMap<List<Object>, Matcher<?>> matcherMap) {
        for (List<CompositeMatcher<?>> compositeMatchers : allCompositeMatchers) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            CompositeMatcher matcher2 = (CompositeMatcher)CollectionsKt.last(compositeMatchers);
            Iterable iterable = CollectionsKt.withIndex((Iterable)matcher2.getOperandValues());
            CompositeMatcher compositeMatcher = matcher2;
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void $dstr$nOp$_u24__u24;
                IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                int nOp = $dstr$nOp$_u24__u24.component1();
                Iterable $this$map$iv2 = compositeMatchers;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    CompositeMatcher compositeMatcher2 = (CompositeMatcher)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(InternalPlatform.INSTANCE.packRef(it.getOperandValues().get(nOp)));
                }
                List signature = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
                this$0.getLog().trace((Function0<String>)((Function0)new Function0<String>(nOp, matcher2, (List<? extends Object>)signature){
                    final /* synthetic */ int $nOp;
                    final /* synthetic */ CompositeMatcher<?> $matcher;
                    final /* synthetic */ List<Object> $signature;
                    {
                        this.$nOp = $nOp;
                        this.$matcher = $matcher;
                        this.$signature = $signature;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Signature for " + this.$nOp + " operand of " + this.$matcher + " composite matcher: " + this.$signature;
                    }
                }));
                Matcher<Object> matcher3 = (Matcher<Object>)((Map)matcherMap).remove(signature);
                collection.add(matcher3 == null ? ChainedCallDetector.Companion.eqOrNullMatcher(matcher2.getOperandValues().get(nOp)) : matcher3);
            }
            compositeMatcher.setSubMatchers((List)destination$iv$iv);
        }
    }
}

