/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.workflow;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.sonatype.nexus.maven.staging.workflow.AbstractStagingActionMojo;

public abstract class AbstractStagingBuildActionMojo
extends AbstractStagingActionMojo {
    @Parameter(property="stagingRepositoryId")
    private String stagingRepositoryId;

    protected String[] getStagingRepositoryIds() throws MojoExecutionException {
        String[] result = null;
        if (this.stagingRepositoryId != null) {
            result = (String[])Iterables.toArray((Iterable)Splitter.on((String)",").split((CharSequence)this.stagingRepositoryId), String.class);
        }
        if (result == null) {
            ArrayList<String> resultNames = new ArrayList<String>();
            File stageRoot = this.getStagingDirectoryRoot();
            File[] localStageRepositories = stageRoot.listFiles();
            if (localStageRepositories == null) {
                this.getLog().info((CharSequence)"We have nothing locally staged, bailing out.");
                result = null;
            } else {
                for (File profileDirectory : localStageRepositories) {
                    String managedStagingRepositoryId;
                    if (!profileDirectory.isFile() || !profileDirectory.getName().endsWith(".properties") || (managedStagingRepositoryId = this.readStagingRepositoryIdFromPropertiesFile(profileDirectory)) == null) continue;
                    resultNames.add(managedStagingRepositoryId);
                }
            }
            result = resultNames.toArray(new String[resultNames.size()]);
        }
        if (result == null || result.length == 0) {
            throw new MojoExecutionException("The staging repository to operate against is not defined! (use \"-DstagingRepositoryId=foo1,foo2\" on CLI)");
        }
        return result;
    }

    protected String readStagingRepositoryIdFromPropertiesFile(File stagingRepositoryPropertiesFile) throws MojoExecutionException {
        if (stagingRepositoryPropertiesFile.isFile()) {
            Properties stagingRepositoryProperties = new Properties();
            try {
                FileInputStream fis = new FileInputStream(stagingRepositoryPropertiesFile);
                stagingRepositoryProperties.load(fis);
                boolean managed = Boolean.valueOf(stagingRepositoryProperties.getProperty("stagingRepository.managed"));
                if (managed) {
                    return stagingRepositoryProperties.getProperty("stagingRepository.id");
                }
                return null;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unexpected IO exception while loading up staging properties from " + stagingRepositoryPropertiesFile.getAbsolutePath(), (Exception)e);
            }
        }
        throw new MojoExecutionException("Unexpected input: this is not a properties file: " + stagingRepositoryPropertiesFile.getAbsolutePath());
    }

    @Override
    protected boolean shouldExecute() {
        return this.isThisLastProjectWithThisMojoInExecution();
    }
}

