/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Objects;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.codehaus.plexus.util.WriterFactory;

public abstract class AbstractTextSinkFactory
implements SinkFactory {
    protected abstract Sink createSink(Writer var1, String var2);

    public Sink createSink(File outputDir, String outputName) throws IOException {
        return this.createSink(outputDir, outputName, "UTF-8");
    }

    public Sink createSink(File outputDir, String outputName, String encoding) throws IOException {
        Objects.requireNonNull(outputDir, "outputDir cannot be null");
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        } else if (!outputDir.isDirectory()) {
            throw new IllegalArgumentException("The dir '" + outputDir + "' is not a directory.");
        }
        Writer writer = WriterFactory.newWriter((File)new File(outputDir, outputName), (String)encoding);
        return this.createSink(writer, encoding);
    }

    public Sink createSink(OutputStream out) throws IOException {
        return this.createSink(out, "UTF-8");
    }

    public Sink createSink(OutputStream out, String encoding) throws IOException {
        return this.createSink(new OutputStreamWriter(out, encoding), encoding);
    }
}

