/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jwt;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b\u00a2\u0006\u0002\u0010\tJ&\u0010\u0010\u001a\u0004\u0018\u00018\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0086\u0002\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jitsi/jwt/RefreshingProperty;", "T", "", "timeout", "Ljava/time/Duration;", "clock", "Ljava/time/Clock;", "creationFunc", "Lkotlin/Function0;", "(Ljava/time/Duration;Ljava/time/Clock;Lkotlin/jvm/functions/Function0;)V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "value", "Ljava/lang/Object;", "valueCreationTimestamp", "Ljava/time/Instant;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "valueExpired", "", "now", "jicoco-jwt"})
public class RefreshingProperty<T> {
    @NotNull
    private final Duration timeout;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Function0<T> creationFunc;
    @Nullable
    private T value;
    @Nullable
    private Instant valueCreationTimestamp;
    @NotNull
    private final Logger logger;

    public RefreshingProperty(@NotNull Duration timeout, @NotNull Clock clock, @NotNull Function0<? extends T> creationFunc) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(creationFunc, (String)"creationFunc");
        this.timeout = timeout;
        this.clock = clock;
        this.creationFunc = creationFunc;
        this.logger = LoggerExtensionsKt.createLogger$default((Object)this, null, null, (int)3, null);
    }

    public /* synthetic */ RefreshingProperty(Duration duration, Clock clock, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(duration, clock, function0);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final synchronized T getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Instant now = this.clock.instant();
        Intrinsics.checkNotNull((Object)now);
        if (this.valueExpired(now)) {
            Object object;
            RefreshingProperty refreshingProperty;
            RefreshingProperty refreshingProperty2 = this;
            try {
                refreshingProperty = refreshingProperty2;
                this.logger.debug((Object)("Refreshing property " + property.getName() + " (not yet initialized or expired)..."));
                object = this.creationFunc.invoke();
            }
            catch (Exception exception) {
                void exception2;
                refreshingProperty = refreshingProperty2;
                this.logger.warn((Object)("Property refresh caused exception, will use null for property " + property.getName() + ": "), (Throwable)exception2);
                object = null;
            }
            refreshingProperty.value = object;
            this.valueCreationTimestamp = now;
        }
        return this.value;
    }

    private final boolean valueExpired(Instant now) {
        return this.value == null || Duration.between(this.valueCreationTimestamp, now).compareTo(this.timeout) >= 0;
    }
}

