/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.workflow;

import com.sonatype.nexus.staging.client.StagingRuleFailuresException;
import com.sonatype.nexus.staging.client.StagingWorkflowV2Service;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.sonatype.nexus.client.core.NexusClient;
import org.sonatype.nexus.client.core.exception.NexusClientErrorResponseException;
import org.sonatype.nexus.maven.staging.AbstractStagingMojo;
import org.sonatype.nexus.maven.staging.ErrorDumper;
import org.sonatype.nexus.maven.staging.StagingAction;
import org.sonatype.nexus.maven.staging.remote.Parameters;
import org.sonatype.nexus.maven.staging.remote.RemoteNexus;

public abstract class AbstractStagingActionMojo
extends AbstractStagingMojo {
    private NexusClient nexusClient;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.failIfOffline();
        if (this.shouldExecute()) {
            StagingWorkflowV2Service stagingWorkflow = this.createStagingWorkflowService();
            try {
                this.doExecute(stagingWorkflow);
            }
            catch (NexusClientErrorResponseException e) {
                ErrorDumper.dumpErrors(this.getLog(), e);
                throw new MojoExecutionException("Could not perform action: Nexus ErrorResponse received!", (Exception)((Object)e));
            }
            catch (StagingRuleFailuresException e) {
                ErrorDumper.dumpErrors(this.getLog(), e);
                throw new MojoExecutionException("Could not perform action: there are failing staging rules!", (Exception)((Object)e));
            }
        }
    }

    protected String getDescriptionWithDefaultsForAction(StagingAction action) throws MojoExecutionException {
        return this.getStagingActionMessages().getMessageForAction(action);
    }

    protected boolean shouldExecute() {
        return true;
    }

    protected abstract void doExecute(StagingWorkflowV2Service var1) throws MojoExecutionException, MojoFailureException;

    protected StagingWorkflowV2Service createStagingWorkflowService() throws MojoExecutionException {
        try {
            Parameters parameters = this.buildParameters();
            RemoteNexus remoteNexus = new RemoteNexus(this.getMavenSession(), this.getSecDispatcher(), this.getLog().isDebugEnabled(), parameters);
            return remoteNexus.getStagingWorkflowV2Service();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Nexus connection problem: " + e.getMessage(), e);
        }
    }
}

