/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.c2s.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.fsm.LoginContext;
import org.jivesoftware.smack.fsm.State;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.fsm.StateDescriptorGraph;
import org.jivesoftware.smack.fsm.StateTransitionResult;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.Objects;
import org.jxmpp.jid.parts.Resourcepart;

public final class WalkStateGraphContext {
    private final Class<? extends StateDescriptor> initialStateClass;
    private final Class<? extends StateDescriptor> finalStateClass;
    private final Class<? extends StateDescriptor> mandatoryIntermediateState;
    private final LoginContext loginContext;
    private final List<State> walkedStateGraphPath = new ArrayList<State>();
    final Map<State, StateTransitionResult> failedStates = new LinkedHashMap<State, StateTransitionResult>();
    boolean mandatoryIntermediateStateHandled;

    WalkStateGraphContext(Builder builder) {
        this.initialStateClass = builder.initialStateClass;
        this.finalStateClass = builder.finalStateClass;
        this.mandatoryIntermediateState = builder.mandatoryIntermediateState;
        this.loginContext = builder.loginContext;
    }

    public void recordWalkTo(State state) {
        this.walkedStateGraphPath.add(state);
    }

    public boolean isWalksFinalState(StateDescriptor stateDescriptor) {
        return stateDescriptor.getClass() == this.finalStateClass;
    }

    public boolean isFinalStateAuthenticatedAndResourceBound() {
        return this.finalStateClass == ModularXmppClientToServerConnection.AuthenticatedAndResourceBoundStateDescriptor.class;
    }

    public StateDescriptorGraph.GraphVertex<State> maybeReturnMandatoryImmediateState(List<StateDescriptorGraph.GraphVertex<State>> outgoingStateEdges) {
        for (StateDescriptorGraph.GraphVertex<State> outgoingStateVertex : outgoingStateEdges) {
            if (outgoingStateVertex.getElement().getStateDescriptor().getClass() != this.mandatoryIntermediateState) continue;
            this.mandatoryIntermediateStateHandled = true;
            return outgoingStateVertex;
        }
        return null;
    }

    public List<State> getWalk() {
        return CollectionUtil.newListWith(this.walkedStateGraphPath);
    }

    public int getWalkLength() {
        return this.walkedStateGraphPath.size();
    }

    public void appendWalkTo(List<State> walk) {
        walk.addAll(this.walkedStateGraphPath);
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    public boolean stateAlreadyVisited(State state) {
        return this.walkedStateGraphPath.contains(state);
    }

    public void recordFailedState(State state, StateTransitionResult stateTransitionResult) {
        this.failedStates.put(state, stateTransitionResult);
    }

    public Map<State, StateTransitionResult> getFailedStates() {
        return new HashMap<State, StateTransitionResult>(this.failedStates);
    }

    public boolean wouldCauseCycle(StateDescriptorGraph.GraphVertex<State> successorStateVertex) {
        HashSet<Class<? extends StateDescriptor>> visited = new HashSet<Class<? extends StateDescriptor>>();
        return this.wouldCycleRecursive(successorStateVertex, visited);
    }

    private boolean wouldCycleRecursive(StateDescriptorGraph.GraphVertex<State> stateVertex, Set<Class<? extends StateDescriptor>> visited) {
        Class<?> stateVertexClass = stateVertex.getElement().getStateDescriptor().getClass();
        if (stateVertexClass == this.initialStateClass) {
            return true;
        }
        if (this.finalStateClass == stateVertexClass || visited.contains(stateVertexClass)) {
            return false;
        }
        visited.add(stateVertexClass);
        for (StateDescriptorGraph.GraphVertex<State> successorStateVertex : stateVertex.getOutgoingEdges()) {
            boolean cycle = this.wouldCycleRecursive(successorStateVertex, visited);
            if (!cycle) continue;
            return true;
        }
        return false;
    }

    public static Builder builder(Class<? extends StateDescriptor> initialStateClass, Class<? extends StateDescriptor> finalStateClass) {
        return new Builder(initialStateClass, finalStateClass);
    }

    public static final class Builder {
        private final Class<? extends StateDescriptor> initialStateClass;
        private final Class<? extends StateDescriptor> finalStateClass;
        private Class<? extends StateDescriptor> mandatoryIntermediateState;
        private LoginContext loginContext;

        private Builder(Class<? extends StateDescriptor> initialStateClass, Class<? extends StateDescriptor> finalStateClass) {
            this.initialStateClass = Objects.requireNonNull(initialStateClass);
            this.finalStateClass = Objects.requireNonNull(finalStateClass);
        }

        public Builder withMandatoryIntermediateState(Class<? extends StateDescriptor> mandatoryIntermedidateState) {
            this.mandatoryIntermediateState = mandatoryIntermedidateState;
            return this;
        }

        public Builder withLoginContext(String username, String password, Resourcepart resource) {
            LoginContext loginContext = new LoginContext(username, password, resource);
            return this.withLoginContext(loginContext);
        }

        public Builder withLoginContext(LoginContext loginContext) {
            this.loginContext = loginContext;
            return this;
        }

        public WalkStateGraphContext build() {
            return new WalkStateGraphContext(this);
        }
    }
}

