/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.model.Extension;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.model.io.stax.CoreExtensionsStaxReader;
import org.codehaus.mojo.versions.utils.ExtensionBuilder;

public final class CoreExtensionUtils {
    public static Stream<Extension> getCoreExtensions(MavenProject project) throws IOException, XMLStreamException {
        Path extensionsFile = project.getBasedir().toPath().resolve(".mvn/extensions.xml");
        if (!Files.isRegularFile(extensionsFile, new LinkOption[0])) {
            return Stream.empty();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(extensionsFile, new OpenOption[0])));){
            Stream<Extension> stream = new CoreExtensionsStaxReader().read(reader).getExtensions().stream().map(ex -> ExtensionBuilder.newBuilder().withGroupId(ex.getGroupId()).withArtifactId(ex.getArtifactId()).withVersion(ex.getVersion()).build());
            return stream;
        }
    }
}

