/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.charger.internal;

import java.util.List;
import java.util.concurrent.Callable;
import org.sonatype.sisu.charger.CallableExecutor;
import org.sonatype.sisu.charger.ChargeFuture;
import org.sonatype.sisu.charger.ChargeStrategy;
import org.sonatype.sisu.charger.Charger;
import org.sonatype.sisu.charger.ExceptionHandler;
import org.sonatype.sisu.charger.internal.Charge;
import org.sonatype.sisu.charger.internal.Check;
import org.sonatype.sisu.charger.internal.DefaultChargeFuture;
import org.sonatype.sisu.charger.internal.NopExceptionHandler;

public class DefaultCharger
implements Charger {
    @Override
    public <E> ChargeFuture<E> submit(List<Callable<E>> callables, ChargeStrategy<E> strategy, CallableExecutor executorServiceProvider) {
        Check.notNull(callables, "Callables are null!");
        Charge<E> charge = this.getChargeInstance(strategy);
        for (Callable<E> callable : callables) {
            charge.addAmmo(callable, callable instanceof ExceptionHandler ? (ExceptionHandler)((Object)callable) : NopExceptionHandler.NOOP);
        }
        return this.submit(charge, executorServiceProvider);
    }

    @Override
    public <E> ChargeFuture<E> submit(List<Callable<E>> callables, ExceptionHandler exceptionHandler, ChargeStrategy<E> strategy, CallableExecutor executorServiceProvider) {
        Check.notNull(callables, "Callables are null!");
        Charge<E> charge = this.getChargeInstance(strategy);
        for (Callable<E> callable : callables) {
            charge.addAmmo(callable, exceptionHandler);
        }
        return this.submit(charge, executorServiceProvider);
    }

    @Override
    public <E> ChargeFuture<E> submit(Charge<E> charge, CallableExecutor callableExecutor) {
        Check.notNull(charge, "Charge is null!");
        charge.exec(callableExecutor);
        return new DefaultChargeFuture<E>(charge);
    }

    protected <E> Charge<E> getChargeInstance(ChargeStrategy<E> strategy) {
        return new Charge<E>(strategy);
    }
}

