/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import org.apache.commons.beanutils.BeanUtils;
import org.sonatype.nexus.client.core.spi.SubsystemSupport;
import org.sonatype.nexus.client.core.subsystem.config.Segment;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.GlobalConfigurationResource;
import org.sonatype.nexus.rest.model.GlobalConfigurationResourceResponse;

public abstract class JerseySegmentSupport<ME extends Segment, S>
extends SubsystemSupport<JerseyNexusClient>
implements Segment<ME, S> {
    private final S settings = Preconditions.checkNotNull(this.createSettings());
    private GlobalConfigurationResource configuration;

    public JerseySegmentSupport(JerseyNexusClient nexusClient) {
        super(nexusClient);
        this.refresh();
    }

    @Override
    public S settings() {
        return this.settings;
    }

    @Override
    public ME refresh() {
        this.configuration = (GlobalConfigurationResource)Preconditions.checkNotNull((Object)this.getConfiguration());
        this.copy(this.getSettingsFrom(this.configuration), this.settings);
        return this.me();
    }

    @Override
    public ME save() {
        this.setSettingsIn(this.settings, this.configuration);
        this.setConfiguration(this.configuration);
        return this.refresh();
    }

    protected abstract S getSettingsFrom(GlobalConfigurationResource var1);

    protected abstract void setSettingsIn(S var1, GlobalConfigurationResource var2);

    protected abstract S createSettings();

    private void copy(S configurationSettings, S localSettings) {
        S toCopy = configurationSettings;
        if (configurationSettings == null) {
            toCopy = this.createSettings();
        }
        try {
            BeanUtils.copyProperties(localSettings, toCopy);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    ME me() {
        return (ME)this;
    }

    @VisibleForTesting
    GlobalConfigurationResource getConfiguration() {
        try {
            return ((GlobalConfigurationResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource("global_settings/current").get(GlobalConfigurationResourceResponse.class)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @VisibleForTesting
    void setConfiguration(GlobalConfigurationResource configuration) {
        GlobalConfigurationResourceResponse request = new GlobalConfigurationResourceResponse();
        request.setData(configuration);
        try {
            ((JerseyNexusClient)this.getNexusClient()).serviceResource("global_settings/current").put((Object)request);
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }
}

