/*
 * Decompiled with CFR 0.152.
 */
package com.github.gantsign.maven.plugin.ktlint;

import com.pinterest.ktlint.cli.reporter.core.api.KtlintCliError;
import com.pinterest.ktlint.cli.reporter.core.api.ReporterV2;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\rH\u0016J\f\u0010\u0019\u001a\u00020\u000b*\u00020\u000bH\u0002J\f\u0010\u001a\u001a\u00020\u000b*\u00020\u000bH\u0002J\u0014\u0010\u0007\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/github/gantsign/maven/plugin/ktlint/MavenLogReporter;", "Lcom/pinterest/ktlint/cli/reporter/core/api/ReporterV2;", "log", "Lorg/apache/maven/plugin/logging/Log;", "verbose", "", "groupByFile", "pad", "(Lorg/apache/maven/plugin/logging/Log;ZZZ)V", "acc", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/pinterest/ktlint/cli/reporter/core/api/KtlintCliError;", "getGroupByFile", "()Z", "getLog", "()Lorg/apache/maven/plugin/logging/Log;", "getPad", "getVerbose", "after", "", "file", "onLintError", "ktlintCliError", "dir", "name", "length", "", "Companion", "ktlint-maven-plugin"})
@SourceDebugExtension(value={"SMAP\nMavenLogReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenLogReporter.kt\ncom/github/gantsign/maven/plugin/ktlint/MavenLogReporter\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n72#2,2:110\n1#3:112\n*S KotlinDebug\n*F\n+ 1 MavenLogReporter.kt\ncom/github/gantsign/maven/plugin/ktlint/MavenLogReporter\n*L\n51#1:110,2\n51#1:112\n*E\n"})
public final class MavenLogReporter
implements ReporterV2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Log log;
    private final boolean verbose;
    private final boolean groupByFile;
    private final boolean pad;
    @NotNull
    private final ConcurrentHashMap<String, List<KtlintCliError>> acc;
    @NotNull
    private static final String NAME = "maven";

    public MavenLogReporter(@NotNull Log log, boolean verbose, boolean groupByFile, boolean pad) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
        this.verbose = verbose;
        this.groupByFile = groupByFile;
        this.pad = pad;
        this.acc = new ConcurrentHashMap();
    }

    @NotNull
    public final Log getLog() {
        return this.log;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final boolean getGroupByFile() {
        return this.groupByFile;
    }

    public final boolean getPad() {
        return this.pad;
    }

    public void onLintError(@NotNull String file, @NotNull KtlintCliError ktlintCliError) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)ktlintCliError, (String)"ktlintCliError");
        int line = ktlintCliError.getLine();
        int col = ktlintCliError.getCol();
        String ruleId = ktlintCliError.getRuleId();
        String detail = ktlintCliError.getDetail();
        if (this.groupByFile) {
            ConcurrentMap $this$getOrPut$iv = this.acc;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(file);
            if (object == null) {
                boolean bl = false;
                ArrayList default$iv = new ArrayList();
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(file, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkNotNull(object);
            ((List)object).add(ktlintCliError);
            return;
        }
        MessageBuilder buf = MessageUtils.buffer().a((CharSequence)this.dir(file)).strong((Object)this.name(file)).a((CharSequence)":").strong((Object)line).a((CharSequence)this.pad("" + ':' + col + ':', 4)).a((CharSequence)" ").failure((Object)detail);
        if (this.verbose) {
            buf.a((CharSequence)(" (" + ruleId + ')'));
        }
        this.log.error((CharSequence)buf.toString());
    }

    public void after(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.groupByFile) {
            return;
        }
        List<KtlintCliError> list = this.acc.get(file);
        if (list == null) {
            return;
        }
        List<KtlintCliError> errList = list;
        this.log.error((CharSequence)MessageUtils.buffer().a((CharSequence)this.dir(file)).strong((Object)this.name(file)).toString());
        for (KtlintCliError err : errList) {
            int line = err.getLine();
            int col = err.getCol();
            String ruleId = err.getRuleId();
            String detail = err.getDetail();
            MessageBuilder buf = MessageUtils.buffer().a((CharSequence)" ").strong((Object)line).a((CharSequence)this.pad("" + ':' + col, 4)).a((CharSequence)" ").failure((Object)detail);
            if (this.verbose) {
                buf.a((CharSequence)(" (" + ruleId + ')'));
            }
            this.log.error((CharSequence)buf.toString());
        }
    }

    private final String pad(String $this$pad, int length) {
        return this.pad ? StringsKt.padEnd$default((String)$this$pad, (int)length, (char)'\u0000', (int)2, null) : $this$pad;
    }

    private final String dir(String $this$dir) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        return stringBuilder.append(StringsKt.substringBeforeLast$default((String)$this$dir, (String)string, null, (int)2, null)).append(File.separator).toString();
    }

    private final String name(String $this$name) {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        return StringsKt.substringAfterLast$default((String)$this$name, (String)string, null, (int)2, null);
    }

    public void afterAll() {
        ReporterV2.DefaultImpls.afterAll((ReporterV2)this);
    }

    public void before(@NotNull String file) {
        ReporterV2.DefaultImpls.before((ReporterV2)this, (String)file);
    }

    public void beforeAll() {
        ReporterV2.DefaultImpls.beforeAll((ReporterV2)this);
    }

    @NotNull
    public static final String getNAME() {
        return Companion.getNAME();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/github/gantsign/maven/plugin/ktlint/MavenLogReporter$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "ktlint-maven-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

