/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Formatter;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="verify", threadSafe=true, defaultPhase=LifecyclePhase.VERIFY)
public final class VerifyBundlePlugin
extends AbstractMojo {
    private static final String EXPORT_PACKAGE = "Export-Package";
    private Pattern skipDirs = Pattern.compile("(META|OSGI)-INF(.*)");
    @Component
    private MavenProject project;
    @Parameter(property="skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="failOnError", defaultValue="true")
    protected boolean failOnError;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Verify execution");
            return;
        }
        Set<String> packagesNotFound = this.checkPackages();
        if (!packagesNotFound.isEmpty()) {
            Formatter formatter = new Formatter();
            formatter.format("Current bundle %s exports packages that do not exist:%n", this.project.getArtifact().getFile());
            for (String packageNotFound : packagesNotFound) {
                formatter.format(" * %s%n", packageNotFound);
            }
            formatter.format("Please review the <Export-Package> instruction in the `configuration/instructions` element of the `maven-bundle-plugin`%n", new Object[0]);
            formatter.format("For more details, see http://bnd.bndtools.org/heads/export_package.html", new Object[0]);
            String message = formatter.toString();
            formatter.close();
            if (this.failOnError) {
                throw new MojoFailureException(message);
            }
            this.getLog().warn((CharSequence)message);
        }
    }

    private Set<String> checkPackages() throws MojoExecutionException {
        TreeSet<String> treeSet;
        TreeSet<String> packagesNotFound = new TreeSet<String>();
        File bundle = this.project.getArtifact().getFile();
        ZipInputStream input = null;
        try {
            Clause[] clauses;
            input = new JarInputStream(new FileInputStream(bundle));
            Manifest manifest = ((JarInputStream)input).getManifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            String exportPackage = mainAttributes.getValue(EXPORT_PACKAGE);
            if (exportPackage == null || exportPackage.isEmpty()) {
                this.getLog().warn((CharSequence)"Bundle manifest file does not contain valid 'Export-Package' OSGi entry, it will be ignored");
                TreeSet<String> treeSet2 = packagesNotFound;
                return treeSet2;
            }
            for (Clause clause : clauses = Parser.parseHeader((String)exportPackage)) {
                packagesNotFound.add(clause.getName());
            }
            JarEntry jarEntry = null;
            while ((jarEntry = ((JarInputStream)input).getNextJarEntry()) != null) {
                String entryName = jarEntry.getName();
                if (!jarEntry.isDirectory() || this.skipDirs.matcher(entryName).matches()) continue;
                if (File.separatorChar == entryName.charAt(entryName.length() - 1)) {
                    entryName = entryName.substring(0, entryName.length() - 1);
                }
                String currentPackage = entryName.replace(File.separatorChar, '.');
                packagesNotFound.remove(currentPackage);
            }
            treeSet = packagesNotFound;
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("An error occurred while reading manifest file " + bundle, (Exception)ioe);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return treeSet;
    }
}

