/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ReservedMembersAndConstructsForInlineClass;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "Companion", "frontend"})
public final class ReservedMembersAndConstructsForInlineClass
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> reservedFunctions;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (!InlineClassesUtilsKt.isInlineClass(containingDeclaration)) {
            return;
        }
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return;
        }
        DeclarationDescriptor declarationDescriptor2 = descriptor2;
        if (declarationDescriptor2 instanceof SimpleFunctionDescriptor) {
            KtFunction ktFunction = declaration2 instanceof KtFunction ? (KtFunction)declaration2 : null;
            if (ktFunction == null) {
                return;
            }
            KtFunction ktFunction2 = ktFunction;
            String string2 = ((SimpleFunctionDescriptor)descriptor2).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"descriptor.name.asString()");
            String functionName = string2;
            if (reservedFunctions.contains(functionName)) {
                PsiElement psiElement = ktFunction2.getNameIdentifier();
                if (psiElement == null) {
                    return;
                }
                PsiElement nameIdentifier = psiElement;
                context2.getTrace().report(Errors.RESERVED_MEMBER_INSIDE_VALUE_CLASS.on(nameIdentifier, functionName));
            }
        } else if (declarationDescriptor2 instanceof ConstructorDescriptor) {
            KtSecondaryConstructor ktSecondaryConstructor = declaration2 instanceof KtSecondaryConstructor ? (KtSecondaryConstructor)declaration2 : null;
            if (ktSecondaryConstructor == null) {
                return;
            }
            KtSecondaryConstructor secondaryConstructor = ktSecondaryConstructor;
            KtBlockExpression bodyExpression = secondaryConstructor.getBodyExpression();
            if (secondaryConstructor.hasBlockBody() && bodyExpression != null) {
                PsiElement psiElement = bodyExpression.getLBrace();
                if (psiElement == null) {
                    return;
                }
                PsiElement lBrace = psiElement;
                context2.getTrace().report(Errors.SECONDARY_CONSTRUCTOR_WITH_BODY_INSIDE_VALUE_CLASS.on(lBrace));
            }
        }
    }

    static {
        Object[] objectArray = new String[]{"box", "unbox", "equals", "hashCode"};
        reservedFunctions = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ReservedMembersAndConstructsForInlineClass$Companion;", "", "()V", "reservedFunctions", "", "", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

