#	$NetBSD: getdirs.awk,v 1.6 2013/03/12 13:08:00 njoly Exp $
#
# Copyright (c) 2002 The NetBSD Foundation, Inc.
# All rights reserved.
#
# This code is derived from software contributed to The NetBSD Foundation
# by Luke Mewburn of Wasabi Systems.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
# ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
# TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#


function dirname(file) \
{
	# no need to worry about args that do not contain at least one "/"
	gsub(/\/[^\/]+$/, "", file)
	return file
}

#	skip empty or whitespace-only lines, or lines with comments
#
/^[ 	]*(#|$)/ \
{
	next
}

#	skip mtree config lines
#
/^\/(un)?set/ \
{
	next
}

#	error if consecutive slashes are found
#
/\/\// \
{
	print "Unsupported consecutive slashes in path:" >"/dev/stderr"
	print >"/dev/stderr"
	exit 1
}

#	error if path has a trailing slash
#
/\/$/ \
{
	print "Unsupported path with trailing slash:" >"/dev/stderr"
	print >"/dev/stderr"
	exit 1
}

#	all other lines are parsed 
#
{
	print
	file = $1
	items[file]++
	do {
		file = dirname(file)
		dirs[file]++
	} while (file ~ /\//)
}

END \
{
	for (file in dirs) {
		if (! (file in items))
			print file " optional type=dir"
	}
}
