% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DID_IV_decomposition.R
\name{twfeiv_decomp}
\alias{twfeiv_decomp}
\title{DID-IV decomposition}
\usage{
twfeiv_decomp(formula, data, id_var, time_var, summary_output = FALSE)
}
\arguments{
\item{formula}{A formula object of the form \code{Y ~ D + controls | controls + Z}, where:
\itemize{
\item Y is the outcome variable,
\item D is the treatment variable,
\item Z is a binary instrumental variable, and
\item controls are optional control variables.
Do not include fixed effects (e.g., individual or time dummies) in the control variables.
}}

\item{data}{A data frame containing all variables used in the formula, as well as the variables specified by id_var and time_var.}

\item{id_var}{The name of id variable.}

\item{time_var}{The name of time variable.}

\item{summary_output}{Logical. If TRUE, prints a summary table showing, for each design type, the total weight and the weighted average of the Wald-DID estimates. If FALSE (the default), no summary is printed.}
}
\value{
If no control variables are included in the formula, the function returns a data frame named exposed_unexposed_combinations
which contains the Wald-DID estimates and corresponding weights for each exposed/unexposed cohort pair.

If control variables are included, the function returns a list named decomposition_list containing:
\describe{
\item{within_IV_coefficient}{Numeric. The coefficient from the within-IV regression.}
\item{between_IV_coefficient}{Numeric. The coefficient from the between-IV regression.}
\item{Omega}{Numeric. The weight on the within-IV coefficient in the TWFEIV estimator, such that \eqn{TWFEIV = \Omega \times \text{within} + (1 - \Omega) \times \text{between}}.}
\item{exposed_unexposed_combinations}{A data.frame with the between-IV coefficients and corresponding weights for each exposed/unexposed cohort pair.}
}
}
\description{
twfeiv_decomp() is a function that decomposes the TWFEIV estimator into all possible Wald-DID estimators.
}
\examples{
# Load example dataset
data(simulation_data)
head(simulation_data)

# Example without controls
decomposition_result_without_controls <- twfeiv_decomp(outcome ~ treatment | instrument,
                                      data = simulation_data,
                                      id_var = "id",
                                      time_var = "time")

# Example with controls
decomposition_result_with_controls <- twfeiv_decomp(
  outcome ~ treatment + control1 + control2 |control1 + control2 + instrument,
  data = simulation_data,
  id_var = "id",
  time_var = "time"
)

}
