% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRPCAMS_helpers.R
\name{align}
\alias{align}
\title{Align Loadings of Principal Components}
\usage{
align(PC, type = "largest", vec = NULL)
}
\arguments{
\item{PC}{Array of loadings of size p x k x N as returned by \code{msPCA$PC}.}

\item{type}{Character string specifying the sign adjustment method. One of:
\tabular{ll}{
\code{"largest"} \tab Sets the sign so that the largest (by absolute value) loading is positive, per neighborhood and component. \cr
\code{"maxvar"}  \tab Makes the variable with the highest absolute value positive, per neighborhood and component. \cr
\code{"nonzero"} \tab Makes the loading with the largest distance from zero over neighborhoods positive, per neighborhood and component. \cr
\code{"scalar"}  \tab Adjusts signs so that the scalar product with \code{vec} is positive, per neighborhood and component.
\code{vec} can be a p-dimensional vector used across all components and neighborhoods, a (p x k) matrix for individual vectors for components,
or a (pN x k) matrix with individual vectors for each neighborhood and component \cr
\code{"mean"}    \tab Like \code{"scalar"}, but \code{vec} is the mean of loadings across neighborhoods for each components. \cr
\code{"none"}    \tab No sign adjustment; returns the raw \code{PC}. \cr
}}

\item{vec}{\code{NULL} or vector containing vectors for type \code{"scalar"}.
If \code{vec} is of dimension \code{p × k}, the same \code{vec} is used for all neighborhoods.}
}
\value{
Returns an array of loadings of size \code{p} times \code{k} times \code{N}.
}
\description{
Aligns loadings per neighborhood for better visualization and comparison. Different options are available.
}
\examples{
set.seed(1)

# Note, that in this example the vectors are not feasible loadings.
COVS = list("a"= matrix(runif(16, -1, 1), 4), "b" = matrix(runif(16, -1, 1), 4))
COVS = lapply(COVS, function(x) x \%*\% t(x))

pca = msPCA(eta = 1, gamma = 0.5, COVS = COVS, k = 2)
x = pca$PC

align(PC = x, type = "largest")
align(PC = x, type = "maxvar")
align(PC = x, type = "mean")
align(PC = x, type = "nonzero")
align(PC = x, type = "scalar", vec = c(1,1,1,1))
}
