% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmwm.r
\name{summary.gmwm}
\alias{summary.gmwm}
\title{Summary of GMWM object}
\usage{
\method{summary}{gmwm}(
  object,
  inference = NULL,
  bs.gof = NULL,
  bs.gof.p.ci = NULL,
  bs.theta.est = NULL,
  bs.ci = NULL,
  B = 100,
  ...
)
}
\arguments{
\item{object}{A \code{GMWM} object}

\item{inference}{A value containing either: NULL (auto), TRUE, or FALSE}

\item{bs.gof}{A value containing either: NULL (auto), TRUE, FALSE}

\item{bs.gof.p.ci}{A value containing either: NULL (auto), TRUE, FALSE}

\item{bs.theta.est}{A value containing either: NULL (auto), TRUE, FALSE}

\item{bs.ci}{A value containing either: NULL (auto), TRUE, FALSE}

\item{B}{An \code{int} that indicates how many bootstraps should be performed.}

\item{...}{Other arguments passed to specific methods}
}
\value{
A \code{summary.gmwm} object with:
 \item{estimate}{Estimated Theta Values}
 \item{testinfo}{Goodness of Fit Information}
 \item{inference}{Inference performed? T/F}
 \item{bs.gof}{Bootstrap GOF? T/F}
 \item{bs.gof.p.ci}{Bootstrap GOF P-Value CI? T/F}
 \item{bs.theta.est}{Bootstrap Theta Estimates? T/F}
 \item{bs.ci}{Bootstrap CI? T/F}
 \item{starting}{Indicates if program supplied initial starting values}
 \item{seed}{Seed used during guessing / bootstrapping}
 \item{obj.fun}{Value of obj.fun at minimized theta}
 \item{N}{Length of Time Series}
}
\description{
Displays summary information about GMWM object
}
\author{
JJB
}
