% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{deriv_wn}
\alias{deriv_wn}
\title{Analytic D Matrix for a Gaussian White Noise (WN) Process}
\usage{
deriv_wn(tau)
}
\arguments{
\item{tau}{A \code{vec} containing the scales e.g. \eqn{2^{\tau}}{2^tau}}
}
\value{
A \code{matrix} with the first column containing 
the partial derivative with respect to \eqn{\sigma^2}{sigma^2}.
}
\description{
Obtain the first derivative of the Gaussian White Noise (WN) process.
}
\section{Process Haar WV First Derivative}{

Taking the derivative with respect to \eqn{\sigma^2}{sigma^2} yields:
\deqn{\frac{\partial }{{\partial {\sigma ^2}}}\nu _j^2\left( {{\sigma ^2}} \right) = \frac{1}{{{\tau _j}}}}{d/dsigma2 nu[j]^2(sigma2) = 1/tau[j]}
}

\author{
James Joseph Balamuta (JJB)
}
