% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicPieceGrob.R
\name{basicPieceGrobs}
\alias{basicPieceGrobs}
\alias{basicPieceGrob}
\alias{picturePieceGrobFn}
\alias{pyramidTopGrob}
\alias{previewLayoutGrob}
\title{Piece Grob Functions}
\usage{
basicPieceGrob(piece_side, suit, rank, cfg = pp_cfg())

picturePieceGrobFn(directory, filename_fn = find_pp_file)

pyramidTopGrob(piece_side, suit, rank, cfg = pp_cfg())

previewLayoutGrob(piece_side, suit, rank, cfg = pp_cfg())
}
\arguments{
\item{piece_side}{A string with piece and side separated by a underscore e.g. "coin_face"}

\item{suit}{Number of suit (starting from 1).}

\item{rank}{Number of rank (starting from 1)}

\item{cfg}{Piecepack configuration list or \code{\link[=pp_cfg]{pp_cfg()}} object.}

\item{directory}{Directory that \code{picturePieceGrobFn} will look in for piece graphics.}

\item{filename_fn}{Function that takes arguments \code{directory}, \code{piece_side}, \code{suit},
\code{rank}, and optionally \code{cfg} and returns the (full path) filename of the image that the
function returned by \code{picturePieceGrobFn} should import.}
}
\description{
\code{basicPieceGrob()} is the most common
\dQuote{grob} function that \code{\link[=grid.piece]{grid.piece()}} uses
to create \code{grid} graphical \code{grob} objects.
\code{picturePieceGrobFn()} is a function that returns a \dQuote{grob} function
that imports graphics from files found in its \code{directory} argument.
}
\examples{

 if (requireNamespace("grid", quietly = TRUE) && piecepackr:::device_supports_unicode()) {
   cfg <- pp_cfg(list(grob_fn.tile=basicPieceGrob, invert_colors=TRUE))
   grid.piece("tile_face", suit=1, rank=3, cfg=cfg)
 }

 \donttest{# May take more than 5 seconds on CRAN servers
 try({
   if (requireNamespace("grid", quietly = TRUE) && capabilities(c("cairo"))) {
     cfg <- pp_cfg(list(grob_fn.tile=basicPieceGrob, invert_colors=TRUE))
     directory <- tempdir()
     save_piece_images(cfg, directory=directory, format="svg", angle=0)
     cfg2 <- pp_cfg(list(grob_fn=picturePieceGrobFn(directory)))

     grid::grid.newpage()
     grid.piece("coin_back", suit=3, rank=5, cfg=cfg2)
   }
 })
 }
}
