% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McCullagh_quasi_symmetry.R
\name{McCullagh_quasi_symmetry}
\alias{McCullagh_quasi_symmetry}
\title{Fits McCullagh's (1978) quasi-symmetry model.}
\usage{
McCullagh_quasi_symmetry(n, max_iter = 15, verbose = FALSE)
}
\arguments{
\item{n}{matrix of observed counts}

\item{max_iter}{maximum number of iterations in maximizing log(likelihood), Default is 15.}

\item{verbose}{should cycle-by-cycle information be printed out? Default is FALSE,
do not print}
}
\value{
a list containing
   phi: symmetry matrix
   alpha: vector of asymmetry parameters
   chisq: Pearson chi-square value
   df; degrees of freedom
}
\description{
McCullagh, P. (1978).  A class of parametric models for the analysis of
square contingency tables with ordered categories.  Biometrika, 65(2) 413-418.
}
\examples{
McCullagh_quasi_symmetry(vision_data)
}
