% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{mc_read_long}
\alias{mc_read_long}
\title{Reading data from long data.frame}
\usage{
mc_read_long(data_table, sensor_ids = list(), clean = TRUE, silent = FALSE)
}
\arguments{
\item{data_table}{long data.frame with Columns:
\itemize{
\item locality_id - character; id of locality
\item sensor_name - can be any character string, recommended are these: \code{names(mc_data_sensors)}
\item datetime - POSIXct in UTC timezone is required
\item value
}}

\item{sensor_ids}{list with relations between sensor_names and sensor_ids (default list());
sensor_id is key from \code{names(mc_data_sensors)}. E.g.,
\code{sensor_ids <- list(precipitation="real", maxAirT="T_C")}
If sensor_name is the same as sensor_id does not have to be provided.}

\item{clean}{if TRUE, then \link{mc_prep_clean} is called automatically while reading (default TRUE)}

\item{silent}{if TRUE, then any information is not printed in console (default FALSE)}
}
\value{
myClim object in Raw-format
}
\description{
This is universal function designed to read time series and values
from long data.frame to myClim object.
}
\details{
Similar like \link{mc_read_wide} but is capable to read multiple sensors
from single table. Useful for data not coming from supported microclimatic
loggers. E.g. meteorological station data.
By default data are cleaned with function \code{\link[=mc_prep_clean]{mc_prep_clean()}}.
}
\seealso{
\link{mc_read_wide}
}
