% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSquadCoefficients.R
\name{getSquadCoefficients}
\alias{getSquadCoefficients}
\title{Return a dataframe that contains squad ratings for a given iteration ID}
\usage{
getSquadCoefficients(iteration, token, host = "https://api.impect.com")
}
\arguments{
\item{iteration}{'IMPECT' iteration ID}

\item{token}{bearer token}

\item{host}{host environment}
}
\value{
a dataframe containing the squad ratings for the given iteration ID
}
\description{
Return a dataframe that contains squad ratings for a given iteration ID
}
\examples{
# Toy example: this will error quickly (no API token)
try(squad_ratings <- getSquadRatings(
  iteration = 0,
  token = "invalid"
))

# Real usage: requires valid Bearer Token from `getAccessToken()`
\dontrun{
squad_ratings <- getSquadRatings(
  iteration = 1004,
  token = "yourToken"
)
}
}
