% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf-formula.R
\name{make_hrf}
\alias{make_hrf}
\title{Create an HRF from a basis specification}
\usage{
make_hrf(basis, lag, nbasis = 1)
}
\arguments{
\item{basis}{Character name of a built-in HRF, a function that
generates HRF values, or an object of class `HRF`.}

\item{lag}{Numeric scalar giving the shift in seconds applied to the
HRF.}

\item{nbasis}{Integer specifying the number of basis functions when
`basis` is provided as a name.}
}
\value{
An object of class `HRF` representing the lagged basis.
}
\description{
`make_hrf` resolves a basis specification to an `HRF` object and
applies an optional temporal lag. The basis may be given as the name
of a built-in HRF, as a generating function, or as an existing `HRF`
object.
}
\examples{
# Canonical SPM HRF delayed by 2 seconds
h <- make_hrf("spmg1", lag = 2)
h(0:5)

}
