% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censuspyrID.R
\docType{data}
\name{pop5}
\alias{pop5}
\alias{hpop5}
\alias{ypop5}
\title{Population Counts in 5-Year Age Groups from Indonesian Censuses}
\format{
Each dataset is a tibble (data frame) with the following variables:
\describe{
\item{\code{year}}{Census year.}
\item{\code{province_id_h}}{Harmonized province identifier (in \code{hpop5}).}
\item{\code{province_id_y}}{non-harmonized province identifier (in \code{ypop5}).}
\item{\code{sex}}{Sex code.}
\item{\code{age5}}{Age group in 5-year intervals.}
\item{\code{ns}}{Unsmoothed population count.}
\item{\code{arriaga}}{Population count smoothed with the Arriaga method.}
\item{\code{kkn}}{Population count smoothed with the Karup–King–Newton method.}
}
\itemize{
\item \code{hpop5}: 5,500 observations.
\item \code{ypop5}: 6,146 observations.
}
}
\source{
Ruggles, S., Cleveland, L., Lovaton, R., Sarkar, S., Sobek, M., Burk, D.,
Ehrlich, D., Heimann, Q., Lee, J., & Merrill, N. (2025).
\emph{Integrated Public Use Microdata Series, International: Version 7.7} (dataset).
Minneapolis, MN: IPUMS. \doi{10.18128/D020.V7.7}

Badan Pusat Statistik (BPS). (2020).
\emph{Jumlah Penduduk Menurut Wilayah, Kelompok Umur, dan Jenis Kelamin,
di INDONESIA – Sensus Penduduk 2020.}
Retrieved September 4, 2025, from \url{https://sensus.bps.go.id/topik/tabular/sp2020/3}
}
\description{
Population counts in 5-year age groups at the provincial level (subnational level 1),
derived from a series of Indonesian population censuses. Data are available in two
versions:
\itemize{
\item \code{hpop5} — Harmonized province codes across census years.
\item \code{ypop5} — Original (non-harmonized) province codes as reported in each census.
}

Both datasets are processed from census samples provided by IPUMS International
(1971–2010) and the Population Census 2020. Data processing steps include prorating
to allocate missing attributes and smoothing using multiple demographic methods
(Arriaga and Karup–King–Newton).
}
\examples{
library(dplyr)

# Harmonized data
data(hpop5)
glimpse(hpop5)
head(hpop5)

# Non-harmonized data
data(ypop5)
glimpse(ypop5)
head(ypop5)

}
\references{
Ruggles, S., Cleveland, L., Lovaton, R., Sarkar, S., Sobek, M., Burk, D.,
Ehrlich, D., Heimann, Q., Lee, J., & Merrill, N. (2025).
\emph{Integrated Public Use Microdata Series, International: Version 7.7} (dataset).
Minneapolis, MN: IPUMS. \doi{10.18128/D020.V7.7}

Badan Pusat Statistik (BPS). (2020).
\emph{Jumlah Penduduk Menurut Wilayah, Kelompok Umur, dan Jenis Kelamin,
di INDONESIA – Sensus Penduduk 2020.}
Retrieved September 4, 2025, from \url{https://sensus.bps.go.id/topik/tabular/sp2020/3}

Siegel, J. S., Swanson, D. A., & Shryock, H. S. (Eds.). (2004).
The methods and materials of demography (2nd ed). Elsevier/Academic Press.

Aburto, J. M., Kashnitsky, I., Pascariu, M., & Riffe, T. (2022).
\emph{Smoothing with DemoTools.}
Available at: \url{https://timriffe.github.io/DemoTools/articles/smoothing_with_demotools.html#references-1}
}
\keyword{datasets}
