% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolators.R
\name{cardinal_quintic_b_spline}
\alias{cardinal_quintic_b_spline}
\title{Cardinal Quintic B-Spline Interpolator}
\usage{
cardinal_quintic_b_spline(
  y,
  t0,
  h,
  left_endpoint_derivatives = NULL,
  right_endpoint_derivatives = NULL
)
}
\arguments{
\item{y}{Numeric vector of data points to interpolate.}

\item{t0}{Numeric scalar representing the starting point of the data.}

\item{h}{Numeric scalar representing the spacing between data points.}

\item{left_endpoint_derivatives}{Optional two-element numeric vector for the derivative at the left endpoint.}

\item{right_endpoint_derivatives}{Optional two-element numeric vector for the derivative at the right endpoint.}
}
\value{
An object of class \code{cardinal_quintic_b_spline} with methods:
\itemize{
\item \code{interpolate(xi)}: Evaluate the interpolator at point \code{xi}.
\item \code{prime(xi)}: Evaluate the derivative of the interpolator at point \code{xi}.
\item \code{double_prime(xi)}: Evaluate the second derivative of the interpolator at point \code{xi}.
}
}
\description{
Constructs a cardinal quintic B-spline interpolator given control points.
}
\examples{
y <- seq(0, 1, length.out = 20)
t0 <- 0
h <- 1
interpolator <- cardinal_quintic_b_spline(y, t0, h)
xi <- 0.5
interpolator$interpolate(xi)
interpolator$prime(xi)
interpolator$double_prime(xi)
}
