% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blas_extras.R
\name{dsymm}
\alias{dsymm}
\title{Symmetric matrix-matrix multiplication}
\usage{
dsymm(
  SIDE = "L",
  UPLO = "U",
  M = NULL,
  N = NULL,
  ALPHA = 1,
  A,
  LDA = NULL,
  B,
  LDB = NULL,
  BETA = 0,
  C,
  LDC = NULL
)
}
\arguments{
\item{SIDE}{Character specifying whether `A` multiplies from the left (`"L"`) or right (`"R"`).}

\item{UPLO}{Character indicating whether `A` stores the upper (`"U"`) or lower (`"L"`) triangle.}

\item{M, N}{Optional integers for the output dimensions.}

\item{ALPHA, BETA}{Numeric scalars.}

\item{A}{Symmetric matrix or big.matrix.}

\item{LDA, LDB, LDC}{Leading dimensions.}

\item{B}{Input matrix.}

\item{C}{Optional output container updated in place.}
}
\value{
Invisibly returns `C`.
}
\description{
Computes \eqn{C := \alpha \operatorname{op}(A) B + \beta C} when `A` is symmetric.
}
\examples{
A <- matrix(c(2, 1, 1, 3), 2, 2)
B <- diag(2)
C <- matrix(0, 2, 2)
dsymm(A = A, B = B, C = C)
C

}
