% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autodb.r
\name{autodb}
\alias{autodb}
\title{Create a normalised database from a data frame}
\usage{
autodb(
  df,
  keep_rownames = FALSE,
  digits = getOption("digits"),
  single_ref = FALSE,
  ensure_lossless = TRUE,
  remove_avoidable = FALSE,
  constants_name = "constants",
  progress = FALSE,
  progress_file = "",
  ...
)
}
\arguments{
\item{df}{a data.frame, containing the data to be normalised.}

\item{keep_rownames}{a logical or a string, indicating whether to include the
row names as a column. If a string is given, it is used as the name for the
column, otherwise the column is named "row". Like with the other column
names, the function returns an error if this results in duplicate column
names. Set to FALSE by default.}

\item{digits}{a positive integer, indicating how many significant digits are
to be used for numeric and complex variables. This is used for both
pre-formatting in \code{\link{discover}}, and for rounding the data before
use in \code{\link{decompose}}, so that the data satisfies the resulting
schema. A value of \code{NA} results in no rounding. By default, this uses
\code{getOption("digits")}, similarly to \code{\link{format}}. See the
"Floating-point variables" section for \code{\link{discover}} for why this
rounding is necessary for consistent results across different machines. See
the note in \code{\link{print.default}} about \code{digits >=
  16}.}

\item{single_ref}{a logical, FALSE by default. If TRUE, then only one
reference between each relation pair is kept when generating foreign key
references. If a pair has multiple references, the kept reference refers to
the earliest key for the child relation, as sorted by priority order.}

\item{ensure_lossless}{a logical, indicating whether to check whether the
normalisation is lossless. If it is not, then an additional relation is
added to the final "database", containing a key for \code{df}. This is
enough to make the normalisation lossless.}

\item{remove_avoidable}{a logical, indicating whether to remove avoidable
attributes in relations. If so, then an attribute are removed from
relations if the keys can be changed such that it is not needed to preserve
the given functional dependencies.}

\item{constants_name}{a scalar character, giving the name for any relation
created to store constant attributes. If this is the same as a generated
relation name, it will be changed, with a warning, to ensure that all
relations have a unique name.}

\item{progress}{a logical, for whether to display progress to the user during
dependency search in \code{\link{discover}}.}

\item{progress_file}{a scalar character or a connection. If \code{progress}
is non-zero, determines where the progress is written to, in the same way
as the \code{file} argument for \code{\link[base]{cat}}.}

\item{...}{further arguments passed on to \code{\link{discover}}.}
}
\value{
A \code{\link{database}}, containing the data in \code{df} within the
inferred database schema.
}
\description{
This is a wrapper function for applying \code{\link{normalise}},
\code{\link{autoref}}, and \code{\link{decompose}}. This takes a data frame
and converts it straight into a database, which is the main intended use case
for the package.
}
\details{
Since \code{decompose} only works with functional dependencies, not approximate
dependencies, the accuracy in \code{discover} is fixed as 1.
}
\examples{
# simple example
autodb(ChickWeight)
}
